package com.yx.tcbj.center.api.dto.request;

import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthQueryReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/5/12 11:07 AM
 */
@ApiModel(
        value = "ItemAuthExtQueryReqDto",
        description = "商品授权扩展dto"
)
public class ItemAuthExtQueryReqDto extends ItemAuthQueryReqDto {

    @ApiModelProperty(
            name = "businessType",
            value = "业务类型（CATEGORY：类目、BRAND：品牌、SKU：商品sku、BANSKU：禁止的商品sku）"
    )
    private String businessType;

    @ApiModelProperty(
            name = "organizationId",
            value = "当前组织id"
    )
    private Long organizationId;

    @ApiModelProperty(
            name = "queryType",
            value = "查询类型 1:商品授权列表；2:客户详情-全部；3:客户详情-已授权；4:客户详情-未授权；"
    )
    private Integer queryType;

    @ApiModelProperty(
            name = "customerName",
            value = "客户名称"
    )
    private String customerName;

    @ApiModelProperty(
            name = "customerIdList",
            value = "客户id集合"
    )
    private List<Long> customerIdList;

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Integer getQueryType() {
        return queryType;
    }

    public void setQueryType(Integer queryType) {
        this.queryType = queryType;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public List<Long> getCustomerIdList() {
        return customerIdList;
    }

    public void setCustomerIdList(List<Long> customerIdList) {
        this.customerIdList = customerIdList;
    }
}
