/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.ItemShopDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.CommanderInfoMQDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirTreeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.contants.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirIndexDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.FrontShopRelationBackDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.FrontShopRelationBackEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirIndexEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DirectoryServiceImpl
implements IDirectoryService {
    private static Logger logger = LoggerFactory.getLogger(DirectoryServiceImpl.class);
    @Resource
    private DirIndexDas dirIndexDas;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private DirDas dirDas;
    @Resource
    private IDirectoryService directoryService;
    @Resource
    private FrontShopRelationBackDas frontShopRelationBackDas;
    @Value(value="${dtyunxi.boc.shop.instanceId:1240276043307355174}")
    private Long bocInstanceId;
    @Resource(name="directoryItemQueryApi")
    private IDirectoryQueryApi directoryQueryApi;
    private Map<Long, Long> shopIdMap = new HashMap<Long, Long>();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createDefaultItemShelf(DirIndexEo directoryEo) {
        DirIndexEo queryDto = DirIndexEo.newInstance();
        queryDto.setDirUsage("DEFAULT_SHELF");
        queryDto.setInstanceId(directoryEo.getInstanceId());
        if (CollectionUtils.isNotEmpty((Collection)this.dirIndexDas.select((BaseEo)queryDto))) {
            logger.info("\u9ed8\u8ba4\u8d27\u67b6\u5df2\u5b58\u5728\uff0c \u4e0d\u9700\u8981\u521b\u5efa");
            return;
        }
        DirEo dirItem = DirEo.newInstance();
        dirItem.setParentId(ItemConstant.ROOT_NODE);
        dirItem.setName("\u9ed8\u8ba4\u8d27\u67b6");
        dirItem.setCode("DEFAULT_SHELF");
        dirItem.setInstanceId(directoryEo.getInstanceId());
        this.directoryItemService.saveDirectoryItem(dirItem, null);
        directoryEo.setDirUsage("DEFAULT_SHELF");
        directoryEo.setRootId(dirItem.getId());
        directoryEo.setName("\u9ed8\u8ba4\u8d27\u67b6");
        directoryEo.setOwnerId(Long.valueOf(0L));
        this.dirIndexDas.insert((BaseEo)directoryEo);
    }

    @Override
    public int saveDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        directoryEo.setId(null);
        return this.dirIndexDas.insert((BaseEo)directoryEo);
    }

    @Override
    public List<DirIndexEo> queryDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_DIR.getCode(), ItemExceptionCode.NON_EXIST_DIR.getMsg());
        }
        return this.dirIndexDas.select((BaseEo)directoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndex(Long id) {
        if (id == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDas.logicDeleteById(id);
        this.itemShelfService.offShelfByDirId(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDirectory(DirIndexEo directoryEo) {
        if (directoryEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        this.dirIndexDas.updateSelective((BaseEo)directoryEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDirIndexByRootId(Long rootId) {
        if (rootId == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        DirIndexEo temp = new DirIndexEo();
        temp.setRootId(rootId);
        DirIndexEo indexEo = (DirIndexEo)this.dirIndexDas.selectOne((BaseEo)temp);
        if (indexEo != null) {
            this.dirIndexDas.logicDeleteById(indexEo.getId());
            this.itemShelfService.offShelfByDirId(indexEo.getId());
        }
    }

    @Override
    public DirIndexEo queryDefaultItemShelf(Long instanceId) {
        DirIndexEo exam = DirIndexEo.newInstance();
        exam.setDirUsage("DEFAULT_SHELF");
        exam.setInstanceId(instanceId);
        List dirs = this.dirIndexDas.select((BaseEo)exam);
        if (CollectionUtils.isNotEmpty((Collection)dirs)) {
            return (DirIndexEo)dirs.get(0);
        }
        DirIndexEo createElement = DirIndexEo.newInstance();
        createElement.setInstanceId(instanceId);
        this.createDefaultItemShelf(createElement);
        return createElement;
    }

    @Override
    public DirIndexEo queryDirectoryById(Long id) {
        return (DirIndexEo)this.dirIndexDas.selectByPrimaryKey(id);
    }

    @Override
    public List<DirectoryItemRespDto> queryByIds(List<Long> ids, String orderBy) {
        DirEo dirEo = DirEo.newInstance();
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            dirEo.setOrderBy("id");
        } else {
            dirEo.setOrderBy(orderBy);
        }
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        dirEo.setSqlFilters((List)sqlFilters);
        List dirEoList = this.dirDas.select((BaseEo)dirEo);
        ArrayList dirRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)dirEoList, (Collection)dirRespDtoList, DirectoryItemRespDto.class);
        return dirRespDtoList;
    }

    @Override
    public String initShopDir(List<CommanderInfoMQDto> shopList) {
        HashMap shopDirIdMap = new HashMap();
        DirIndexEo dirIndexEo = new DirIndexEo();
        dirIndexEo.setDirUsage("front");
        dirIndexEo.setInstanceId(this.bocInstanceId);
        List<DirIndexEo> directoryEos = this.directoryService.queryDirectory(dirIndexEo);
        if (CollectionUtils.isEmpty(directoryEos)) {
            logger.info("\u67e5\u8be2\u4e0d\u5230\u524d\u53f0\u7c7b\u76ee");
            return null;
        }
        List rootIdsList = directoryEos.stream().map(StdDirIndexEo::getRootId).collect(Collectors.toList());
        ArrayList itemShopDtoList = Lists.newArrayList();
        Map<Long, List<FrontShopRelationBackEo>> frontShopMap = null;
        DirEo dirEo = new DirEo();
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.in((String)"root_id", rootIdsList));
        dirEo.setSqlFilters((List)sqlFilterList);
        List dirEoList = this.dirDas.select((BaseEo)dirEo);
        if (CollectionUtils.isNotEmpty((Collection)dirEoList)) {
            List oldIdsList = dirEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            FrontShopRelationBackEo frontShopRelationBackEo = new FrontShopRelationBackEo();
            sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"front_shop_id", oldIdsList));
            frontShopRelationBackEo.setSqlFilters((List)sqlFilterList);
            List frontShopRelationBackEoList = this.frontShopRelationBackDas.select((BaseEo)frontShopRelationBackEo);
            if (CollectionUtils.isNotEmpty((Collection)frontShopRelationBackEoList)) {
                frontShopMap = frontShopRelationBackEoList.stream().collect(Collectors.groupingBy(FrontShopRelationBackEo::getFrontShopId));
            }
        }
        DirTreeReqDto dirTreeReqDto = new DirTreeReqDto();
        dirTreeReqDto.setInstanceId(this.bocInstanceId);
        dirTreeReqDto.setDirUsage("front");
        List<TreeDto<DirectoryItemRespDto>> trees = this.directoryItemService.queryDirTree(dirTreeReqDto);
        logger.info("\u3010\u8fd9\u662f\u4e00\u68f5\u6811\uff1a{}\u3011", (Object)JSON.toJSONString(trees));
        Map<Long, List<FrontShopRelationBackEo>> finalFrontShopMap = frontShopMap;
        shopList.forEach(shop -> {
            DirIndexEo indexEo = new DirIndexEo();
            indexEo.setDirUsage("shop");
            indexEo.setShopId(shop.getShopId());
            indexEo.setSellerId(shop.getSellerId());
            indexEo.setOwnerId(shop.getUserId());
            indexEo.setName("\u5e97\u94fa\u7c7b\u76ee");
            indexEo.setInstanceId(this.bocInstanceId);
            indexEo.setTenantId(Long.valueOf(1L));
            DirEo dirData = new DirEo();
            dirData.setParentId(Long.valueOf(0L));
            dirData.setName("\u5e97\u94fa\u7c7b\u76ee");
            dirData.setInstanceId(this.bocInstanceId);
            dirData.setTenantId(Long.valueOf(1L));
            Long rootId = this.directoryItemService.saveDirectoryItem(dirData, null);
            indexEo.setRootId(rootId);
            this.dirIndexDas.insert((BaseEo)indexEo);
            this.dealWithTree(rootId, indexEo.getShopId(), rootId, trees);
            if (this.shopIdMap != null && finalFrontShopMap != null) {
                ArrayList frontShopRelationBackEos = Lists.newArrayList();
                Set frontIdSet = finalFrontShopMap.keySet();
                ArrayList arrayList = Lists.newArrayList(frontIdSet);
                for (Long oldFrontId : arrayList) {
                    List backEoList;
                    Long newShopDirId = this.shopIdMap.get(oldFrontId);
                    if (newShopDirId == null || !CollectionUtils.isNotEmpty((Collection)(backEoList = (List)finalFrontShopMap.get(oldFrontId)))) continue;
                    backEoList.forEach(n -> {
                        FrontShopRelationBackEo relationBackEo = new FrontShopRelationBackEo();
                        relationBackEo.setFrontShopId(newShopDirId);
                        relationBackEo.setShopId(shop.getShopId());
                        relationBackEo.setBackId(n.getBackId());
                        frontShopRelationBackEos.add(relationBackEo);
                        ItemShopDto itemShopDto = new ItemShopDto();
                        itemShopDto.setBackDirId(n.getBackId());
                        itemShopDto.setShopId(shop.getShopId());
                        itemShopDto.setDirId(newShopDirId);
                        itemShopDto.setFrontDirId(oldFrontId);
                        itemShopDtoList.add(itemShopDto);
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)frontShopRelationBackEos)) {
                    this.frontShopRelationBackDas.insertBatch((List)frontShopRelationBackEos);
                    shopDirIdMap.put(indexEo.getShopId(), itemShopDtoList);
                }
            }
            this.shopIdMap = new HashMap<Long, Long>();
        });
        return JacksonUtil.toJson(shopDirIdMap);
    }

    private void dealWithTree(Long parentId, Long shopId, Long rootId, List<TreeDto<DirectoryItemRespDto>> trees) {
        for (TreeDto<DirectoryItemRespDto> tree : trees) {
            List children = tree.getChildren();
            DirectoryItemRespDto treeNode = (DirectoryItemRespDto)tree.getNode();
            if (treeNode.getParentId() != 0L) {
                DirEo dir = new DirEo();
                BeanUtils.copyProperties((Object)treeNode, (Object)dir);
                dir.setId(null);
                dir.setCreateTime(null);
                dir.setUpdateTime(null);
                dir.setRootId(rootId);
                dir.setShopId(shopId);
                dir.setParentId(parentId);
                dir.setInstanceId(this.bocInstanceId);
                dir.setTenantId(Long.valueOf(1L));
                parentId = this.directoryItemService.saveDirectoryItem(dir, null);
                this.shopIdMap.put(treeNode.getId(), parentId);
            }
            if (!CollectionUtils.isNotEmpty((Collection)children)) continue;
            this.dealWithSonTree(parentId, shopId, rootId, children);
        }
    }

    private void dealWithSonTree(Long parentId, Long shopId, Long rootId, List<TreeDto<DirectoryItemRespDto>> children) {
        for (int i = 0; i < children.size(); ++i) {
            TreeDto<DirectoryItemRespDto> directoryItemRespDtoTreeDto = children.get(i);
            DirectoryItemRespDto treeDtoNode = (DirectoryItemRespDto)directoryItemRespDtoTreeDto.getNode();
            DirEo dirData = new DirEo();
            BeanUtils.copyProperties((Object)treeDtoNode, (Object)dirData);
            dirData.setId(null);
            dirData.setRootId(rootId);
            dirData.setShopId(shopId);
            dirData.setParentId(parentId);
            dirData.setCreateTime(null);
            dirData.setInstanceId(this.bocInstanceId);
            dirData.setTenantId(Long.valueOf(1L));
            dirData.setUpdateTime(null);
            Long newParentId = this.directoryItemService.saveDirectoryItem(dirData, null);
            this.shopIdMap.put(treeDtoNode.getId(), newParentId);
            if (!CollectionUtils.isNotEmpty((Collection)directoryItemRespDtoTreeDto.getChildren())) continue;
            this.dealWithSonTree(newParentId, shopId, rootId, directoryItemRespDtoTreeDto.getChildren());
        }
    }
}

