/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.item.api.utils.UnitFormatUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.IPcpItemService;
import com.dtyunxi.yundt.cube.center.item.biz.service.impl.AbstractItemExtendServiceImpl;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tcbjItemExtendService")
public class TcbjItemExtendServiceImpl
extends AbstractItemExtendServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TcbjItemExtendServiceImpl.class);
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource(name="${project.domain.prefix:tcbj}PcpItemAdaptorService")
    private IPcpItemService pcpItemService;

    @Override
    public Long addItemExtend(ItemExtendReqDto addReqDto) {
        long id;
        this.dataWrapper(addReqDto);
        ItemExtendEo queryEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getItemCode());
        if (queryEo != null && queryEo.getId() != null) {
            addReqDto.setId(queryEo.getId());
            this.modifyItemExtend(addReqDto);
            id = queryEo.getId();
        } else {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtendEo);
            itemExtendEo.setSpecification(addReqDto.getSpecifications());
            itemExtendEo.setZhTrayNum(StringUtils.isNotBlank((CharSequence)addReqDto.getZhTrayNum()) ? Long.valueOf(Long.parseLong(addReqDto.getZhTrayNum())) : null);
            log.info("\u5546\u54c1\u4fee\u6539\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)itemExtendEo));
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            id = itemExtendEo.getId();
        }
        return id;
    }

    private void dataWrapper(ItemExtendReqDto addReqDto) {
        addReqDto.setVolume((BigDecimal)Optional.ofNullable(addReqDto.getVolume()).map(va -> UnitFormatUtils.formatVolume((BigDecimal)va, (String)Optional.ofNullable(addReqDto.getVolumnUnit()).orElse(UnitFormatUtils.VolumeEnum.CM.getName()), (String)UnitFormatUtils.VolumeEnum.M.getName())).orElse(null));
        addReqDto.setBigBox(addReqDto.getBigRatio());
        this.expirationDateTransfer(addReqDto);
        addReqDto.setVolumnUnit(UnitFormatUtils.VolumeEnum.M.getName());
    }

    private void expirationDateTransfer(ItemExtendReqDto addReqDto) {
        try {
            String STR_ZERO = "0";
            addReqDto.setExpirationUnit(UnitFormatUtils.DateEnum.MONTH.getName());
            if (StrUtil.isNotBlank((CharSequence)addReqDto.getExpiryMonth()) && !Objects.equals(addReqDto.getExpiryMonth(), STR_ZERO)) {
                addReqDto.setExpirationDate(addReqDto.getExpiryMonth());
            } else if (StrUtil.isNotBlank((CharSequence)addReqDto.getExpiryYear()) && !Objects.equals(addReqDto.getExpiryYear(), STR_ZERO)) {
                addReqDto.setExpirationDate(String.valueOf(Integer.parseInt(addReqDto.getExpiryYear()) * 12));
            } else {
                addReqDto.setExpirationDate(null);
            }
        }
        catch (Exception e) {
            log.info("\u8f6c\u6362\u5929\u6570\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void addItemExtendBatch(List<ItemExtendReqDto> addReqDto) {
        addReqDto.stream().forEach(this::addItemExtend);
    }

    @Override
    public void modifyItemExtend(ItemExtendReqDto modifyReqDto) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(modifyReqDto.getId());
        BeanUtil.copyProperties((Object)modifyReqDto, (Object)itemExtendEo, (String[])new String[0]);
        itemExtendEo.setSpecification(modifyReqDto.getSpecifications());
        itemExtendEo.setZhTrayNum(StringUtils.isNotBlank((CharSequence)modifyReqDto.getZhTrayNum()) ? Long.valueOf(Long.parseLong(modifyReqDto.getZhTrayNum())) : null);
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ItemExtendEo::getItemCode, (Object)modifyReqDto.getItemCode())).eq(BaseEo::getDr, (Object)0);
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setClaimPrice(modifyReqDto.getClaimPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
        } else {
            if (modifyReqDto.getRecommendPrice() != null) {
                itemExtendEo1.setRecommendPrice(modifyReqDto.getRecommendPrice());
            }
            if (modifyReqDto.getClaimPrice() != null) {
                itemExtendEo1.setClaimPrice(modifyReqDto.getClaimPrice());
            }
            if (modifyReqDto.getE3ItemCode() != null) {
                itemExtendEo1.setE3ItemCode(modifyReqDto.getE3ItemCode());
            }
            this.itemExtendDas.update((BaseEo)itemExtendEo1);
        }
    }
}

