/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IBundleItemService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bundleItemService")
public class BundleItemServiceImpl
implements IBundleItemService {
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int addBundleItemBatch(List<ItemBundleRelationEo> bundleItemEos) {
        return this.itemBundleRelationDas.insertBatch(bundleItemEos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBundleItem(ItemBundleRelationEo bundleItemEo) {
        this.itemBundleRelationDas.insert((BaseEo)bundleItemEo);
        return bundleItemEo.getId();
    }

    @Override
    public void removeById(Long id) {
        this.itemBundleRelationDas.deleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByItemId(Long itemId) {
        ItemBundleRelationEo bundleItemEo = ItemBundleRelationEo.newInstance();
        bundleItemEo.setItemId(itemId);
        this.itemBundleRelationDas.deleteByExample((BaseEo)bundleItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(List<ItemBundleRelationEo> bundleItemEos) {
        bundleItemEos.forEach(eo -> this.itemBundleRelationDas.deleteById(eo.getId()));
    }

    @Override
    public void modifyBundleItem(ItemBundleRelationEo bundleItemEo) {
        this.itemBundleRelationDas.updateSelective((BaseEo)bundleItemEo);
    }

    @Override
    public ItemBundleRelationEo queryById(Long id) {
        return (ItemBundleRelationEo)this.itemBundleRelationDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<ItemBundleRelationEo> queryByPage(ItemBundleRelationEo bundleItemEo, Integer pageNum, Integer pageSize) {
        return this.itemBundleRelationDas.selectPage((BaseEo)bundleItemEo, pageNum, pageSize);
    }

    @Override
    public List<ItemBundleRelationEo> queryByList(ItemBundleRelationEo bundleItemEo) {
        return this.itemBundleRelationDas.select((BaseEo)bundleItemEo);
    }
}

