/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.impl.CollectionItemServiceImpl;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.CollectionItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.CollectionItemEo;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service
public class CollectionItemServiceImplExt
extends CollectionItemServiceImpl {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CollectionItemDas collectionItemDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CollectionItemEo addCollectionItem(CollectionItemEo collectionItemEo) {
        try {
            CollectionItemEo collectionItem = (CollectionItemEo)this.collectionItemDas.selectOne((BaseEo)collectionItemEo);
            if (collectionItem != null) {
                CollectionItemEo updateItem = new CollectionItemEo();
                updateItem.setId(collectionItem.getId());
                collectionItemEo.setId(collectionItem.getId());
                this.collectionItemDas.updateSelective((BaseEo)updateItem);
            } else {
                collectionItemEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                this.collectionItemDas.insert((BaseEo)collectionItemEo);
            }
            return collectionItemEo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeCollectionItem(Long id) {
        this.collectionItemDas.deleteById(id);
    }

    @Override
    public void removeItem(String itemId, String shopId, Long collectionId) {
        CollectionItemEo collectionItemEo = new CollectionItemEo();
        collectionItemEo.setItemSerial(itemId);
        collectionItemEo.setShopSerial(shopId);
        collectionItemEo.setCollectionId(collectionId);
        this.collectionItemDas.delete((BaseEo)collectionItemEo);
    }
}

