/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmpowerPlatformInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.ICustomerInfoQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmpowerPlatformInfoQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.EmPowerStatus;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.Status;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.EmpowerQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.InitEmpowerInfoReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEmpowerCallbackReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemEmpowerReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMainReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.MiddleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.EmpowerItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ImportEmpowerResultRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.InitEmpowerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemChannelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCountRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemEmpowerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemsEmpowerListRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemEmpowerService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemChannelDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemEmpowerDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemChannelEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemEmpowerEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.EmpowerQueryVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemEmpowerServiceImpl
implements IItemEmpowerService {
    @Resource
    private ItemEmpowerDas itemEmpowerDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemChannelDas itemChannelDas;
    @Resource
    private ItemExtShelfDas itemExtShelfDas;
    @Resource
    private ICustomerInfoQueryApi customerInfoQueryApi;
    @Resource
    private IEmpowerPlatformInfoQueryApi empowerPlatformInfoQueryApi;
    @Resource
    private IItemExtService itemExtService;
    @Resource
    private ICacheService cacheService;
    @Resource
    private OssRegistryVo registryVo;

    @Override
    public void addItemEmpower(List<ItemEmpowerReqDto> addReqDto) {
        ArrayList itemEmpowerEo = new ArrayList();
        DtoHelper.dtoList2EoList(addReqDto, itemEmpowerEo, ItemEmpowerEo.class);
        this.itemEmpowerDas.insertBatch(itemEmpowerEo);
        this.cacheService.delCacheByPattern("empower_item_", "*");
    }

    @Override
    public void modifyItemEmpower(ItemEmpowerReqDto modifyReqDto) {
        ItemEmpowerEo itemEmpowerEo = new ItemEmpowerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemEmpowerEo);
        this.itemEmpowerDas.updateSelective((BaseEo)itemEmpowerEo);
        this.cacheService.delCacheByPattern("empower_item_", "*");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyItemEmpowerBatch(ItemEmpowerReqDto modifyReqDto) {
        if (Objects.isNull(modifyReqDto)) {
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)modifyReqDto.getIds())) {
            return;
        }
        ItemEmpowerEo itemEmpowerEo = new ItemEmpowerEo();
        itemEmpowerEo.setAllowSale(modifyReqDto.getAllowSale());
        itemEmpowerEo.setAuthPlatform(modifyReqDto.getAuthPlatform());
        itemEmpowerEo.setSqlFilters(Arrays.asList(SqlFilter.in((String)"id", (Object)modifyReqDto.getIds())));
        this.itemEmpowerDas.updateSelective((BaseEo)itemEmpowerEo);
        this.cacheService.delCacheByPattern("empower_item_", "*");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemEmpower(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemEmpowerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void itemEmpowerCallback(ItemEmpowerCallbackReqDto itemEmpowerCallbackReqDto) {
        ItemEmpowerEo itemEmpowerEo = new ItemEmpowerEo();
        itemEmpowerEo.setProcessionCode(itemEmpowerCallbackReqDto.getId());
        List select = this.itemEmpowerDas.select((BaseEo)itemEmpowerEo);
        for (ItemEmpowerEo empowerEo : select) {
            empowerEo.setEmpowerStatus(itemEmpowerCallbackReqDto.getStatus());
            empowerEo.setStatus(Status.STATUS.getCode());
            this.itemEmpowerDas.updateSelective((BaseEo)empowerEo);
        }
        this.cacheService.delCacheByPattern("empower_item_", "*");
    }

    @Override
    public ItemEmpowerRespDto queryById(Long id) {
        ItemEmpowerEo itemEmpowerEo = (ItemEmpowerEo)this.itemEmpowerDas.selectByPrimaryKey(id);
        ItemEmpowerRespDto itemEmpowerRespDto = new ItemEmpowerRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEmpowerEo, (BaseVo)itemEmpowerRespDto);
        return itemEmpowerRespDto;
    }

    @Override
    public List<ItemEmpowerRespDto> queryAllEmpowerByStatus(List<String> empowerStatus, String itemCode) {
        ExtQueryChainWrapper sqlFilters = this.itemEmpowerDas.filter();
        sqlFilters.in((Object)"empower_status", empowerStatus);
        sqlFilters.eq((Object)"item_code", (Object)itemCode);
        List empowerEoList = sqlFilters.list();
        ArrayList<ItemEmpowerRespDto> respDtoList = new ArrayList<ItemEmpowerRespDto>();
        CubeBeanUtils.copyCollection(respDtoList, (Collection)empowerEoList, ItemEmpowerRespDto.class);
        return respDtoList;
    }

    @Override
    public List<ItemEmpowerRespDto> queryByItemCodes(List<String> itemCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        sqlFilterList.in((Object)"item_code", itemCodes);
        ArrayList<Integer> itemEmpowerStatus = new ArrayList<Integer>();
        itemEmpowerStatus.add(EmPowerStatus.DEFAULT.getStatus());
        itemEmpowerStatus.add(EmPowerStatus.ADOPT.getStatus());
        sqlFilterList.in((Object)"empower_status", itemEmpowerStatus);
        List select = sqlFilterList.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public List<ItemEmpowerRespDto> queryByCustomerCodes(List<String> customerCodes) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(customerCodes)) {
            return Lists.newArrayList();
        }
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        sqlFilterList.in((Object)"customer_code", customerCodes);
        ArrayList<Integer> itemEmpowerStatus = new ArrayList<Integer>();
        itemEmpowerStatus.add(EmPowerStatus.DEFAULT.getStatus());
        itemEmpowerStatus.add(EmPowerStatus.ADOPT.getStatus());
        sqlFilterList.in((Object)"empower_status", itemEmpowerStatus);
        List select = sqlFilterList.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public PageInfo<ItemEmpowerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemEmpowerReqDto itemEmpowerReqDto = (ItemEmpowerReqDto)JSON.parseObject((String)filter, ItemEmpowerReqDto.class);
        ItemEmpowerEo itemEmpowerEo = new ItemEmpowerEo();
        DtoHelper.dto2Eo((BaseVo)itemEmpowerReqDto, (BaseEo)itemEmpowerEo);
        PageInfo eoPageInfo = this.itemEmpowerDas.selectPage((BaseEo)itemEmpowerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemEmpowerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemsEmpowerListRespDto> queryEmpowerPage(ItemMainReqDto mainReqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemDas.filter().orderByDesc((Object)"update_time");
        this.setQueryCondition((ExtQueryChainWrapper<ItemEo>)sqlFilters, mainReqDto);
        PageInfo eoPageInfo = sqlFilters.page(mainReqDto.getPage(), mainReqDto.getSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemsEmpowerListRespDto.class);
        dtoList.stream().forEach(v -> {
            ItemEo eo;
            ArrayList channelRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)this.itemChannelDas.selectByItemIds(Arrays.asList(v.getId())), channelRespDtoList, ItemChannelRespDto.class);
            v.setChannelRespDtoList(channelRespDtoList);
            ArrayList empowerRespDtoList = new ArrayList();
            DtoHelper.eoList2DtoList((Collection)this.itemEmpowerDas.selectByItemIds(Arrays.asList(v.getId()), EmPowerStatus.ADOPT.getStatus()), empowerRespDtoList, ItemEmpowerRespDto.class);
            v.setEmpowerRespDtoList(empowerRespDtoList);
            v.setEmpowerCount(Integer.valueOf(empowerRespDtoList.size()));
            ItemChannelEo channelEo = new ItemChannelEo();
            channelEo.setItemId(v.getId());
            List channelEoList = this.itemChannelDas.select((BaseEo)channelEo);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)channelEoList)) {
                List platformNames = channelEoList.stream().map(ItemChannelEo::getPlatformName).distinct().collect(Collectors.toList());
                v.setPlatformNames(String.join((CharSequence)",", platformNames));
            }
            v.setItemName((eo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"id", (Object)v.getId())).one()) != null ? eo.getName() : null);
            v.setItemCode(eo != null ? eo.getCode() : null);
            v.setItemId(eo != null ? eo.getId() : null);
            v.setProdLargeClass(eo != null ? eo.getProdLargeClass() : null);
            v.setProdSecClassify(eo != null ? eo.getProdSecClassify() : null);
            v.setProdThrClassify(eo != null ? eo.getProdThrClassify() : null);
            v.setProdClassCode(eo != null ? eo.getProdClassCode() : null);
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void setQueryCondition(ExtQueryChainWrapper<ItemEo> sqlFilters, ItemMainReqDto mainReqDto) {
        if (StringUtils.isNotEmpty((CharSequence)mainReqDto.getItemName())) {
            sqlFilters.like((Object)"name", (Object)mainReqDto.getItemName());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainReqDto.getItemCode())) {
            sqlFilters.like((Object)"code", (Object)mainReqDto.getItemCode());
        }
        if (null != mainReqDto.getDirId()) {
            sqlFilters.eq((Object)"dir_id", (Object)mainReqDto.getDirId());
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdLargeClass())) {
            sqlFilters.like((Object)"prod_large_class", (Object)("%" + mainReqDto.getProdLargeClass() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdLargeCode())) {
            sqlFilters.like((Object)"prod_large_code", (Object)("%" + mainReqDto.getProdLargeCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdSecClassify())) {
            sqlFilters.like((Object)"prod_sec_classify", (Object)("%" + mainReqDto.getProdSecClassify() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdSecCode())) {
            sqlFilters.like((Object)"prod_sec_code", (Object)("%" + mainReqDto.getProdSecCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdThrClassify())) {
            sqlFilters.like((Object)"prod_thr_classify", (Object)("%" + mainReqDto.getProdThrClassify() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdThrCode())) {
            sqlFilters.like((Object)"prod_thr_code", (Object)("%" + mainReqDto.getProdThrCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdClassCode())) {
            sqlFilters.like((Object)"prod_class_code", (Object)("%" + mainReqDto.getProdClassCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdClassName())) {
            sqlFilters.like((Object)"prod_class_name", (Object)("%" + mainReqDto.getProdClassName() + "%"));
        }
    }

    @Override
    public List<ItemEmpowerRespDto> queryItemEmpower(Long customerId, String itemIds, String itemCodes) {
        if (customerId == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        sqlFilterList.eq((Object)"customer_id", (Object)customerId);
        sqlFilterList.eq((Object)"status", (Object)Status.STATUS.getCode());
        sqlFilterList.eq((Object)"empower_status", (Object)Status.STATUS.getCode());
        if (StringUtils.isNotBlank((CharSequence)itemIds)) {
            sqlFilterList.in((Object)"item_id", new Object[]{itemIds});
        }
        if (StringUtils.isNotBlank((CharSequence)itemCodes)) {
            sqlFilterList.in((Object)"item_code", new Object[]{itemCodes});
        }
        List itemEmpowerEoList = sqlFilterList.list();
        ArrayList itemEmpowerRespDtoList = Lists.newArrayListWithExpectedSize((int)itemEmpowerEoList.size());
        DtoHelper.eoList2DtoList((Collection)itemEmpowerEoList, (Collection)itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public PageInfo<ItemEmpowerRespDto> getItemEmpower(Long itemId, Integer empowerStatus, String customerCode, String customerName, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemEmpowerDas.filter().orderByDesc((Object)"create_time");
        sqlFilters.eq((Object)"item_id", (Object)itemId);
        sqlFilters.eq((Object)"empower_status", (Object)empowerStatus);
        if (StringUtils.isNotBlank((CharSequence)customerCode)) {
            sqlFilters.eq((Object)"customer_code", (Object)customerCode);
        }
        if (StringUtils.isNotBlank((CharSequence)customerName)) {
            sqlFilters.like((Object)"customer_name", (Object)("%" + customerName + "%"));
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemEmpowerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<Long> queryItemsByCustomer(Long customerId) {
        String cacheKey = "queryItemsByCustomer_" + String.valueOf(customerId);
        List empowerIds = (List)this.cacheService.getCache("empower_item_", cacheKey, List.class);
        if (null != empowerIds) {
            return empowerIds;
        }
        empowerIds = Lists.newArrayList();
        ItemEmpowerEo emPowerEo = new ItemEmpowerEo();
        emPowerEo.setCustomerId(customerId);
        emPowerEo.setEmpowerStatus(EmPowerStatus.ADOPT.getStatus());
        emPowerEo.setStatus(Status.STATUS.getCode());
        List empowerEos = this.itemEmpowerDas.select((BaseEo)emPowerEo);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)empowerEos)) {
            return Lists.newArrayList();
        }
        List ids = empowerEos.stream().map(ItemEmpowerEo::getItemId).collect(Collectors.toList());
        empowerIds.addAll(ids);
        this.cacheService.setCache("empower_item_", cacheKey, ids);
        return empowerIds;
    }

    @Override
    public PageInfo<ItemEmpowerRespDto> selectItemPageByCustomerId(Long customerId, Integer empowerStatus, String itemCode, String itemName, Integer pageNum, Integer pageSize) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemEmpowerDas.filter().orderByDesc((Object)"update_time");
        sqlFilters.eq((Object)"customer_id", (Object)customerId);
        sqlFilters.eq((Object)"empower_status", (Object)empowerStatus);
        if (StringUtils.isNotBlank((CharSequence)itemCode)) {
            sqlFilters.eq((Object)"item_code", (Object)itemCode);
        }
        if (StringUtils.isNotBlank((CharSequence)itemName)) {
            sqlFilters.like((Object)"item_name", (Object)("%" + itemName + "%"));
        }
        PageInfo eoPageInfo = sqlFilters.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemEmpowerRespDto.class);
        dtoList.stream().forEach(d -> {
            int i;
            String[] split;
            String authPlatform = d.getAuthPlatform();
            String allowSale = d.getAllowSale();
            ArrayList<String> authList = new ArrayList<String>();
            ArrayList<String> allList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)authPlatform)) {
                split = authPlatform.split(",");
                for (i = 0; i < split.length; ++i) {
                    authList.add(split[i]);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)allowSale)) {
                split = allowSale.split(",");
                for (i = 0; i < split.length; ++i) {
                    allList.add(split[i]);
                }
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(allList)) {
                List collect = allList.stream().filter(t -> !authList.contains(t)).collect(Collectors.toList());
                ArrayList list = new ArrayList();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(authList)) {
                    authList.stream().forEach(a -> list.add(a + "(\u5141\u9500)"));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect)) {
                    collect.stream().forEach(c -> list.add(c + "(\u672a\u5141\u9500)"));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                    String allowPlatformName = String.join((CharSequence)",", list);
                    d.setAllowPlatformName(allowPlatformName);
                }
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemCountRespDto> queryItemCountByCustomerId(List<Long> customerIds) {
        List itemCountRespVoList = this.itemEmpowerDas.queryItemCountByCustomerId(customerIds);
        ArrayList<ItemCountRespDto> itemCountRespDtoList = new ArrayList<ItemCountRespDto>();
        CubeBeanUtils.copyCollection(itemCountRespDtoList, (Collection)itemCountRespVoList, ItemCountRespDto.class);
        return itemCountRespDtoList;
    }

    @Override
    public PageInfo<EmpowerItemRespDto> empowerItemPage(EmpowerQueryReqDto reqDto) {
        EmpowerQueryVo reqVo = new EmpowerQueryVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)reqDto, (String[])new String[0]);
        PageInfo voPageInfo = this.itemExtShelfDas.queryEmpowerItemPage(reqVo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)voPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)voPageInfo.getList())) {
            List itemRespDtoList = voPageInfo.getList().stream().map(v -> {
                EmpowerItemRespDto respDto = new EmpowerItemRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(itemRespDtoList);
        }
        return dtoPageInfo;
    }

    @Override
    public List<ItemEmpowerRespDto> selectListByCustomerId(Long customerId) {
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        ArrayList<Integer> empowerStatus = new ArrayList<Integer>();
        empowerStatus.add(EmPowerStatus.DEFAULT.getStatus());
        empowerStatus.add(EmPowerStatus.ADOPT.getStatus());
        sqlFilterList.in((Object)"empower_status", empowerStatus);
        sqlFilterList.eq((Object)"customer_id", (Object)customerId);
        List select = sqlFilterList.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public List<ItemEmpowerRespDto> queryItemIdByCustomerId(Long customerId) {
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        ArrayList<Integer> empowerStatus = new ArrayList<Integer>();
        empowerStatus.add(EmPowerStatus.ADOPT.getStatus());
        sqlFilterList.in((Object)"empower_status", empowerStatus);
        sqlFilterList.eq((Object)"customer_id", (Object)customerId);
        sqlFilterList.eq((Object)"status", (Object)Status.STATUS.getCode());
        List select = sqlFilterList.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public List<ItemEmpowerRespDto> getEmpowerItemListByItemId(Long itemId) {
        ExtQueryChainWrapper sqlFilterList = this.itemEmpowerDas.filter();
        ArrayList<Integer> empowerStatus = new ArrayList<Integer>();
        empowerStatus.add(EmPowerStatus.DEFAULT.getStatus());
        empowerStatus.add(EmPowerStatus.ADOPT.getStatus());
        sqlFilterList.in((Object)"empower_status", empowerStatus);
        sqlFilterList.eq((Object)"item_id", (Object)itemId);
        List select = sqlFilterList.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, itemEmpowerRespDtoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public List<ItemEmpowerRespDto> getExistEmpowerItem(EmpowerQueryReqDto queryReqDto) {
        ExtQueryChainWrapper sqlFilters = this.itemEmpowerDas.filter();
        sqlFilters.in((Object)"item_id", (Collection)queryReqDto.getItemIds());
        sqlFilters.in((Object)"customer_id", (Collection)queryReqDto.getCustomerIds());
        List itemEmpowerEoList = sqlFilters.list();
        ArrayList<ItemEmpowerRespDto> itemEmpowerRespDtoList = new ArrayList<ItemEmpowerRespDto>();
        CubeBeanUtils.copyCollection(itemEmpowerRespDtoList, (Collection)itemEmpowerEoList, ItemEmpowerRespDto.class);
        return itemEmpowerRespDtoList;
    }

    @Override
    public ImportEmpowerResultRespDto initEmpowerInfo(ImportDto importDto) {
        ImportEmpowerResultRespDto importEmpowerResultRespDto = new ImportEmpowerResultRespDto();
        ArrayList initEmpowerInfoReqDtoList = new ArrayList();
        String[] arr = new String[]{"\u5e8f\u53f7", "\u54c1\u7c7b", "\u7269\u6599\u53f7", "\u4ea7\u54c1\u7ec4"};
        HashSet<String> set = new HashSet<String>(Arrays.asList(arr));
        List<Object> maps = new ArrayList();
        try {
            maps = EasyPoiExportUtil.parseImportFile(importDto.getUrl(), ItemConstant.TITLEROWS, BigDecimal.ONE.intValue(), BigDecimal.ZERO.intValue(), BigDecimal.ZERO.intValue(), Map.class);
        }
        catch (Exception e2) {
            throw new BizException(ItemExtExceptionCode.EMPOWER_IMPORT_PARSING_ERROR.getCode(), ItemExtExceptionCode.EMPOWER_IMPORT_PARSING_ERROR.getMsg(), (Throwable)e2);
        }
        maps.forEach(empowerMap -> {
            String itemCode = (String)empowerMap.get("\u7269\u6599\u53f7");
            if (StringUtils.isNotBlank((CharSequence)itemCode)) {
                String itemName = (String)empowerMap.get("\u4ea7\u54c1\u7ec4");
                Set setMap = empowerMap.entrySet();
                for (Map.Entry empower : setMap) {
                    if (set.contains(empower.getKey()) || empower.getValue() == null || !StringUtils.isNotBlank((CharSequence)empower.getValue().toString())) continue;
                    InitEmpowerInfoReqDto initEmpowerInfoReqDto = new InitEmpowerInfoReqDto();
                    if (empower.getKey().toString().contains(".")) {
                        String[] split = empower.getKey().toString().split("\\.");
                        initEmpowerInfoReqDto.setCustomerCode("1220_" + split[0]);
                    } else {
                        initEmpowerInfoReqDto.setCustomerCode("1220_" + empower.getKey().toString());
                    }
                    initEmpowerInfoReqDto.setItemCode(itemCode);
                    initEmpowerInfoReqDto.setItemName(itemName);
                    initEmpowerInfoReqDtoList.add(initEmpowerInfoReqDto);
                }
            }
        });
        List customerCodeList = initEmpowerInfoReqDtoList.stream().map(InitEmpowerInfoReqDto::getCustomerCode).distinct().collect(Collectors.toList());
        RestResponse restResponse = this.customerInfoQueryApi.queryByCodes(customerCodeList);
        List customerInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        Map<String, CustomerInfoRespDto> customerInfoMap = customerInfoRespDtoList.stream().collect(Collectors.toMap(CustomerInfoRespDto::getCode, o -> o));
        List customerIdList = customerInfoRespDtoList.stream().map(CustomerInfoRespDto::getId).collect(Collectors.toList());
        RestResponse response = this.empowerPlatformInfoQueryApi.queryByCustomerIds(customerIdList);
        List platformInfoList = (List)RestResponseHelper.extractData((RestResponse)response);
        Map<String, List<EmpowerPlatformInfoRespDto>> platformInfoMap = platformInfoList.stream().collect(Collectors.groupingBy(EmpowerPlatformInfoRespDto::getCustomerCode));
        Map<String, List<InitEmpowerInfoReqDto>> map = initEmpowerInfoReqDtoList.stream().collect(Collectors.groupingBy(InitEmpowerInfoReqDto::getCustomerCode));
        List<String> itemCodeList = initEmpowerInfoReqDtoList.stream().map(InitEmpowerInfoReqDto::getItemCode).distinct().collect(Collectors.toList());
        this.itemExtService.batchOnShelfItem(itemCodeList);
        ArrayList<InitEmpowerRespDto> initEmpowerRespDtoList = new ArrayList<InitEmpowerRespDto>();
        ArrayList<ItemEmpowerReqDto> itemEmpowerReqDtos = new ArrayList<ItemEmpowerReqDto>();
        for (Map.Entry<String, List<InitEmpowerInfoReqDto>> empowerInfo : map.entrySet()) {
            List<String> empowerCodes;
            ArrayList<MiddleReqDto> middleReqDtoList = new ArrayList<MiddleReqDto>();
            if (!platformInfoMap.containsKey(empowerInfo.getKey())) {
                InitEmpowerRespDto initEmpowerRespDto = new InitEmpowerRespDto();
                initEmpowerRespDto.setCustomerCode(empowerInfo.getKey());
                List<InitEmpowerInfoReqDto> value = empowerInfo.getValue();
                initEmpowerRespDto.setCustomerName(value.get(0).getCustomerName());
                initEmpowerRespDto.setRemark("\u8be5\u5ba2\u6237\u6ca1\u6709\u5141\u9500\u5e73\u53f0,\u5546\u54c1\u65e0\u6cd5\u5141\u9500\uff01");
                initEmpowerRespDtoList.add(initEmpowerRespDto);
                continue;
            }
            CustomerInfoRespDto customerInfoRespDto = customerInfoMap.get(empowerInfo.getKey());
            List<EmpowerPlatformInfoRespDto> empowerPlatformInfoRespDtoList = platformInfoMap.get(empowerInfo.getKey());
            List customerPlatform = empowerPlatformInfoRespDtoList.stream().map(e -> e.getEmpowerPlatformName()).collect(Collectors.toList());
            List<InitEmpowerInfoReqDto> initEmpowerInfoReqDtos = empowerInfo.getValue();
            initEmpowerInfoReqDtos.forEach(init -> {
                ItemChannelEo itemChannelEo = new ItemChannelEo();
                itemChannelEo.setItemCode(init.getItemCode());
                List itemChannelRespDtos = this.itemChannelDas.select((BaseEo)itemChannelEo);
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemChannelRespDtos)) {
                    InitEmpowerRespDto initEmpowerRespDto = new InitEmpowerRespDto();
                    initEmpowerRespDto.setItemName(init.getItemName());
                    initEmpowerRespDto.setItemCode(init.getItemCode());
                    initEmpowerRespDto.setCustomerCode(customerInfoRespDto.getCode());
                    initEmpowerRespDto.setCustomerName(customerInfoRespDto.getName());
                    initEmpowerRespDto.setRemark(ItemExtExceptionCode.ITEM_EMPOWER_PLATFORM_NULL.getMsg());
                    initEmpowerRespDtoList.add(initEmpowerRespDto);
                } else {
                    ArrayList platform = new ArrayList();
                    platform.addAll(customerPlatform);
                    List itemPlatform = itemChannelRespDtos.stream().map(c -> c.getPlatformName()).collect(Collectors.toList());
                    List intersection = platform.stream().filter(customer -> itemPlatform.contains(customer)).collect(Collectors.toList());
                    platform.addAll(itemPlatform);
                    List platformAll = platform.stream().distinct().collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(intersection)) {
                        InitEmpowerRespDto initEmpowerRespDto = new InitEmpowerRespDto();
                        initEmpowerRespDto.setItemName(init.getItemName());
                        initEmpowerRespDto.setItemCode(init.getItemCode());
                        initEmpowerRespDto.setCustomerCode(customerInfoRespDto.getCode());
                        initEmpowerRespDto.setCustomerName(customerInfoRespDto.getName());
                        initEmpowerRespDto.setRemark(ItemExtExceptionCode.CUSTOMER_ITEM_EMPOWER_PLATFORM_NULL.getMsg());
                        initEmpowerRespDtoList.add(initEmpowerRespDto);
                    } else {
                        MiddleReqDto middleReqDto = new MiddleReqDto();
                        middleReqDto.setItemCode(init.getItemCode());
                        middleReqDto.setIntersection(intersection);
                        middleReqDto.setPlatformAll(platformAll);
                        middleReqDtoList.add(middleReqDto);
                    }
                }
            });
            ArrayList errorCodes = new ArrayList();
            List itemEmpowerCodes = middleReqDtoList.stream().map(m -> m.getItemCode()).collect(Collectors.toList());
            List itemEmpowerRespDtoList = ((ExtQueryChainWrapper)this.itemEmpowerDas.filter().in((Object)"item_code", itemEmpowerCodes)).select(new String[0]).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemEmpowerRespDtoList)) {
                itemEmpowerRespDtoList.stream().forEach(item -> {
                    if (item.getCustomerId().equals(customerInfoRespDto.getId())) {
                        InitEmpowerRespDto initEmpowerRespDto = new InitEmpowerRespDto();
                        initEmpowerRespDto.setItemName(item.getItemName());
                        initEmpowerRespDto.setItemCode(item.getItemCode());
                        initEmpowerRespDto.setCustomerCode(customerInfoRespDto.getCode());
                        initEmpowerRespDto.setCustomerName(customerInfoRespDto.getName());
                        initEmpowerRespDto.setRemark(ItemExtExceptionCode.IMPORT_ITEM_CODE_REPEAT.getMsg());
                        initEmpowerRespDtoList.add(initEmpowerRespDto);
                        errorCodes.add(item.getItemCode());
                    }
                });
            }
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(empowerCodes = itemEmpowerCodes.stream().filter(t -> !errorCodes.contains(t)).collect(Collectors.toList()))) continue;
            List<ItemEmpowerReqDto> itemEmpowerList = this.InitEmpowerInfo(empowerCodes, middleReqDtoList, customerInfoRespDto);
            itemEmpowerReqDtos.addAll(itemEmpowerList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemEmpowerReqDtos)) {
            importEmpowerResultRespDto.setSuccessNum(Integer.valueOf(itemEmpowerReqDtos.size()));
            ArrayList itemEmpowerEoList = new ArrayList();
            DtoHelper.dtoList2EoList(itemEmpowerReqDtos, itemEmpowerEoList, ItemEmpowerEo.class);
            this.itemEmpowerDas.insertBatch(itemEmpowerEoList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(initEmpowerRespDtoList)) {
            importEmpowerResultRespDto.setErrorNum(Integer.valueOf(initEmpowerInfoReqDtoList.size() - itemEmpowerReqDtos.size()));
            String excelName = this.registryVo.getDir() + "/\u5141\u9500\u521d\u59cb\u5316\u5bfc\u5165\u5931\u8d25\u5217\u8868\u4fe1\u606f" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            String exportUrl = EasyPoiExportUtil.getExportUrl(initEmpowerRespDtoList, InitEmpowerRespDto.class, "\u5141\u9500\u521d\u59cb\u5316\u5bfc\u5165\u5931\u8d25\u5217\u8868\u4fe1\u606f", excelName, "xls");
            importEmpowerResultRespDto.setUrl(exportUrl);
            return importEmpowerResultRespDto;
        }
        this.cacheService.delCacheByPattern("empower_item_", "*");
        return importEmpowerResultRespDto;
    }

    public List<ItemEmpowerReqDto> InitEmpowerInfo(List<String> itemCodes, List<MiddleReqDto> middleReqDtoList, CustomerInfoRespDto customerInfoRespDto) {
        List itemRespDtos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"code", itemCodes)).select(new String[0]).list();
        List itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"code", itemCodes)).select(new String[0]).list();
        Map<String, List<ItemSkuEo>> itemSkuEoListMap = itemSkuEoList.stream().collect(Collectors.groupingBy(StdItemSkuEo::getCode));
        ArrayList itemEmpowerReqDtos = Lists.newArrayList();
        for (ItemEo itemEo : itemRespDtos) {
            ItemEmpowerReqDto itemEmpowerReqDto = new ItemEmpowerReqDto();
            itemEmpowerReqDto.setItemId(itemEo.getId());
            itemEmpowerReqDto.setItemCode(itemEo.getCode());
            itemEmpowerReqDto.setItemName(itemEo.getName());
            if (CollectionUtils.isEmpty(itemSkuEoListMap)) {
                List<ItemSkuEo> itemSkuEos = itemSkuEoListMap.get(itemEo.getCode());
                itemEmpowerReqDto.setSkuId(org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuEos) ? itemSkuEos.get(0).getId() : null);
            }
            itemEmpowerReqDto.setSapCode(customerInfoRespDto.getSapCode());
            itemEmpowerReqDto.setCustomerChannel(customerInfoRespDto.getSalesChannel());
            itemEmpowerReqDto.setProdSecClassify(itemEo.getProdSecClassify());
            itemEmpowerReqDto.setProdLargeClass(itemEo.getProdLargeClass());
            itemEmpowerReqDto.setCustomerId(customerInfoRespDto.getId());
            itemEmpowerReqDto.setCustomerCode(customerInfoRespDto.getCode());
            itemEmpowerReqDto.setCustomerName(customerInfoRespDto.getName());
            itemEmpowerReqDto.setEmpowerStatus(EmPowerStatus.ADOPT.getStatus());
            itemEmpowerReqDto.setStatus(StatusEnum.ENABLED.getStatus());
            middleReqDtoList.stream().forEach(m -> {
                if (m.getItemCode().equals(itemEo.getCode())) {
                    String authPlatform = String.join((CharSequence)",", m.getIntersection());
                    String allowSale = String.join((CharSequence)",", m.getPlatformAll());
                    itemEmpowerReqDto.setAllowSale(allowSale);
                    itemEmpowerReqDto.setAuthPlatform(authPlatform);
                }
            });
            itemEmpowerReqDtos.add(itemEmpowerReqDto);
        }
        return itemEmpowerReqDtos;
    }
}

