/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.generate;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.item.biz.enus.GenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.item.biz.service.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.item.biz.utils.Assert;
import java.util.Date;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenerateCodeService
implements IGenerateCodeService {
    private Logger logger = LoggerFactory.getLogger(AbstractGenerateCodeService.class);
    protected final String DEFAULT_PREFIX = "";
    protected final String DEFAULT_SUFFIX = "";
    protected final Integer DEFAULT_DIGIT_NUM = 6;
    protected final Integer DEFAULT_MAX_DIGIT_NUM = 13;
    protected final Integer DEFAULT_AUTO_INCREASE_NUM = 1;
    private static final Integer LOCK_TIME_OUT = 30;
    protected final Long DEFAULT_MAX_LIMIT_NUM = 999999999L;
    @Autowired
    private ILockService lockService;
    @Autowired
    private ICacheService cacheService;

    @Override
    public String getGenerateCodeStrategy() {
        return GenerateCodeStrategyEnum.COMMMON.getCode();
    }

    @Override
    public String getCode() {
        return "";
    }

    private String getGenerateCodeKey(String tableName, String lockKey) {
        return "generateCode:" + tableName + "_" + lockKey;
    }

    protected Long queryMaxCode() {
        return 0L;
    }

    protected abstract String lockKey();

    protected String getCodePrefix() {
        return "";
    }

    protected String getCodeSuffix() {
        return "";
    }

    protected String generate(String tableName, String lockKey, Integer digitNum, Integer increaseNum, Integer maxDigitNum) {
        if (null == digitNum) {
            digitNum = this.DEFAULT_DIGIT_NUM;
        }
        if (null == increaseNum) {
            increaseNum = this.DEFAULT_AUTO_INCREASE_NUM;
        }
        if (null == maxDigitNum) {
            maxDigitNum = this.DEFAULT_MAX_DIGIT_NUM;
        }
        return this.getGenerateCode(tableName, lockKey, digitNum, increaseNum, maxDigitNum);
    }

    private String getGenerateCode(String tableName, String lockKey, Integer digitNum, Integer autoIncreaseNum, Integer maxDigitNum) {
        this.logger.info("Generate--->\u751f\u6210\u7f16\u7801\uff0ctableName:{},lockKey:{},digitNum:{}", new Object[]{tableName, lockKey, digitNum});
        Mutex mutex = null;
        try {
            mutex = this.lockService.lock(tableName, lockKey, LOCK_TIME_OUT.intValue());
            if (null == mutex) {
                throw new BizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
            }
            String string = this.doGenerate(tableName, lockKey, autoIncreaseNum, digitNum, maxDigitNum);
            return string;
        }
        catch (Exception e) {
            this.logger.info("\u751f\u6210\u7f16\u7801\u5f02\u5e38\uff1a[tableName:{},lockKey:{}],eMessage:{},e:{}", new Object[]{tableName, lockKey, e.getMessage(), e});
            throw e;
        }
        finally {
            if (null != mutex) {
                this.lockService.unlock(mutex);
            }
        }
    }

    private String doGenerate(String tableName, String lockKey, Integer autoInceeaseNum, Integer digitNum, Integer maxDigitNum) {
        Long generateCode;
        Assert.isTrue((digitNum > 0 ? 1 : 0) != 0, (String)"500", (String)"\u7f16\u7801\u4f4d\u6570\u957f\u5ea6\u53c2\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        digitNum = digitNum > maxDigitNum ? maxDigitNum : digitNum;
        String generateCodeKey = this.getGenerateCodeKey(tableName, lockKey);
        Long maxCode = (Long)this.cacheService.getCache(generateCodeKey, Long.class);
        if (null == maxCode) {
            maxCode = 0L;
        }
        Assert.isTrue(((generateCode = Long.valueOf(maxCode + (long)autoInceeaseNum.intValue())) < this.DEFAULT_MAX_LIMIT_NUM ? 1 : 0) != 0, (String)"500", (String)"\u8d85\u8fc7\u6700\u5927\u7f16\u7801\u9650\u5236");
        this.cacheService.setPersistCache(generateCodeKey, (Object)generateCode);
        return this.assemble(digitNum, generateCode);
    }

    protected String assemble(Integer digitNum, Long generateCode) {
        String prefix = this.getCodePrefix();
        String suffix = this.getCodeSuffix();
        String dateStr = DateUtils.format((Date)new Date(), (String)"MMdd");
        return prefix + dateStr + String.format("%" + digitNum + "d", generateCode).replace(" ", "0") + suffix;
    }
}

