/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeUtil {
    protected static Logger logger = LoggerFactory.getLogger(BarcodeUtil.class);

    public static File generateFile(String msg, String path) {
        File file = new File(path);
        try {
            BarcodeUtil.generate(msg, new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return file;
    }

    public static byte[] generate(String msg) {
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BarcodeUtil.generate(msg, ous);
        return ous.toByteArray();
    }

    public static void generate(String msg, OutputStream ous) {
        if (StringUtils.isEmpty((CharSequence)msg) || ous == null) {
            return;
        }
        Code39Bean bean = new Code39Bean();
        int dpi = 150;
        double moduleWidth = UnitConv.in2mm((double)0.006666666828095913);
        bean.setModuleWidth(moduleWidth);
        bean.setWideFactor(3.0);
        bean.doQuietZone(false);
        String format = "image/png";
        try {
            BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, 150, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateBarCode(String message, Double height, Double width, boolean withQuietZone, boolean hideText) {
        Code128Bean bean = new Code128Bean();
        int dpi = 512;
        bean.doQuietZone(withQuietZone);
        bean.setBarHeight(((Double)ObjectUtils.defaultIfNull((Object)height, (Object)6.0)).doubleValue());
        if (width != null) {
            bean.setModuleWidth(width.doubleValue());
        }
        if (hideText) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        String format = "image/png";
        ByteArrayOutputStream ous = new ByteArrayOutputStream();
        BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)ous, format, dpi, 12, false, 0);
        bean.generateBarcode((CanvasProvider)canvas, message);
        try {
            canvas.finish();
        }
        catch (IOException e) {
            logger.error("\u751f\u6210\u6761\u5f62\u7801\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return ous.toByteArray();
    }

    public static void main(String[] args) {
        String msg = "6950386605013";
        byte[] bytes = BarcodeUtil.generateBarCode("6950386605013", 10.0, 0.3, true, false);
        String base64 = DatatypeConverter.printBase64Binary((byte[])bytes);
        System.out.println(base64);
    }
}

