/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BaseReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageDetailQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BundleItemStorageDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageDetailQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemStorageService;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="itemStorageQueryApi")
public class ItemStorageQueryApiImpl
implements IItemStorageQueryApi {
    @Resource
    private IItemStorageService itemStorageService;

    public RestResponse<List<ItemStorageQueryRespDto>> queryBranchItemStorage(ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto) {
        List<ItemStorageQueryRespDto> itemStorageQueryRespDtos = this.itemStorageService.queryBranchItemStorage(itemStorageBranchQueryReqDto);
        return new RestResponse(itemStorageQueryRespDtos);
    }

    public RestResponse<List<ItemStorageQueryRespDto>> queryItemStorage(String filter) {
        ArrayList<ItemStorageQueryReqDto> itemStorageQueryReqDtoList = new ArrayList<ItemStorageQueryReqDto>();
        Long instanceId = null;
        Long tenantId = null;
        if (filter.startsWith("{")) {
            ItemStorageQueryReqDto itemStorageQueryReqDto = (ItemStorageQueryReqDto)JSON.parseObject((String)filter, ItemStorageQueryReqDto.class);
            itemStorageQueryReqDtoList.add(itemStorageQueryReqDto);
            instanceId = itemStorageQueryReqDto.getInstanceId();
            tenantId = itemStorageQueryReqDto.getTenantId();
        } else {
            if (!filter.startsWith("[")) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            JSONArray array = JSON.parseArray((String)filter);
            if (CollectionUtils.isEmpty((Collection)array)) {
                throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
            }
            for (int i = 0; i < array.size(); ++i) {
                ItemStorageQueryReqDto itemStorageQueryReqDto = (ItemStorageQueryReqDto)JSON.parseObject((String)array.getString(0), ItemStorageQueryReqDto.class);
                itemStorageQueryReqDtoList.add(itemStorageQueryReqDto);
                if (instanceId == null) {
                    instanceId = itemStorageQueryReqDto.getInstanceId();
                }
                if (tenantId != null) continue;
                tenantId = itemStorageQueryReqDto.getTenantId();
            }
        }
        return new RestResponse(this.itemStorageService.queryItemStorage(itemStorageQueryReqDtoList, instanceId, tenantId));
    }

    public RestResponse<PageInfo<ItemStorageDetailQueryRespDto>> queryItemStorageDetail(String filter, Integer pageNum, Integer pageSize) {
        ItemStorageDetailQueryReqDto itemStorageDetailQueryReqDto = (ItemStorageDetailQueryReqDto)JSON.parseObject((String)filter, ItemStorageDetailQueryReqDto.class);
        if (itemStorageDetailQueryReqDto != null && itemStorageDetailQueryReqDto.getInstanceId() != null && itemStorageDetailQueryReqDto.getTenantId() != null) {
            return new RestResponse(this.itemStorageService.queryItemStorageDetail(itemStorageDetailQueryReqDto, pageNum, pageSize));
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
    }

    public RestResponse<ItemStorageDetailQueryRespDto> queryItemStorageDetail(Long id, String filter) {
        BaseReqDto baseReqDto = (BaseReqDto)JSON.parseObject((String)filter, BaseReqDto.class);
        if (baseReqDto != null && baseReqDto.getInstanceId() != null && baseReqDto.getTenantId() != null) {
            return new RestResponse((Object)this.itemStorageService.queryItemStorageDetail(id, baseReqDto.getInstanceId(), baseReqDto.getTenantId()));
        }
        throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
    }

    public RestResponse<List<BundleItemStorageDto>> queryBundleItemStorage(Long itemId, Long shopId) {
        List<BundleItemStorageDto> bundleItemStorageDtoList = this.itemStorageService.queryBundleItemStorage(itemId, shopId);
        return new RestResponse(bundleItemStorageDtoList);
    }
}

