/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BundleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemChangeApplyDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemVersionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemVersionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.constants.ItemType;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemVersionService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemBundleRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemChangeApplyDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemTagRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemVersionDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemBundleRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemTagRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemVersionEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="iItemVersionService")
public class ItemVersionServiceImpl
implements IItemVersionService {
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemChangeApplyDas itemChangeApplyDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemBundleRelationDas itemBundleRelationDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemTagRelationDas itemTagRelationDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private ItemVersionDas itemVersionDas;
    @Resource
    private ItemPropRelationDas itemPropRelationDas;

    @Override
    public Long addItemVersion(Long itemId) {
        ItemChangeApplyDto itemChangeApplyDto = this.queryItemSnapshotByItemId(itemId);
        if (itemChangeApplyDto == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.RECORD_NOT_EXIST);
        }
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (itemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM);
        }
        ItemVersionEo itemVersionEo = new ItemVersionEo();
        itemVersionEo.setItemId(itemId);
        itemVersionEo.setVersion(itemEo.getVersion());
        itemVersionEo.setSnapshot(JSON.toJSONString((Object)itemChangeApplyDto));
        itemVersionEo.setInstanceId(itemEo.getInstanceId());
        itemVersionEo.setTenantId(itemEo.getTenantId());
        this.itemVersionDas.insert((BaseEo)itemVersionEo);
        return itemVersionEo.getId();
    }

    @Override
    public List<ItemVersionRespDto> queryItemVersion(ItemVersionReqDto itemVersionReqDto) {
        if (itemVersionReqDto == null || itemVersionReqDto.getInstanceId() == null || itemVersionReqDto.getTenantId() == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR);
        }
        ItemVersionEo itemVersionEo = ItemVersionEo.newInstance((Map)itemVersionReqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)itemVersionReqDto, (BaseEo)itemVersionEo);
        List itemVersionEoList = this.itemVersionDas.select((BaseEo)itemVersionEo);
        ArrayList<ItemVersionRespDto> itemVersionRespDtoList = new ArrayList<ItemVersionRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)itemVersionEoList)) {
            for (ItemVersionEo eo : itemVersionEoList) {
                ItemVersionRespDto itemVersionRespDto = new ItemVersionRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)itemVersionRespDto);
                itemVersionRespDto.setItemChangeApplyDto((ItemChangeApplyDto)JSON.parseObject((String)eo.getSnapshot(), ItemChangeApplyDto.class));
                itemVersionRespDtoList.add(itemVersionRespDto);
            }
        }
        return itemVersionRespDtoList;
    }

    @Override
    public ItemChangeApplyDto queryItemSnapshotByItemId(Long itemId) {
        List<Long> tagIdList;
        ItemChangeApplyDto itemChangeApplyDto = new ItemChangeApplyDto();
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (itemEo == null) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM);
        }
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemChangeApplyDto);
        itemChangeApplyDto.setItemName(itemEo.getName());
        itemChangeApplyDto.setItemCode(itemEo.getCode());
        itemChangeApplyDto.setItemId(itemId);
        List<ItemBundleReqDto> itemBundleReqDtoList = this.queryItemBundle(itemEo.getId(), itemEo.getType(), itemEo.getInstanceId(), itemEo.getTenantId());
        itemChangeApplyDto.setSkus(itemBundleReqDtoList);
        List<ItemMediasReqDto> itemMediasReqDtoList = this.queryItemMedias(itemEo.getId(), null, itemEo.getInstanceId(), itemEo.getTenantId());
        itemChangeApplyDto.setMedias(itemMediasReqDtoList);
        ItemAttributesEo itemAttributesEo = this.queryItemAttribute(itemEo.getId(), itemEo.getInstanceId(), itemEo.getTenantId());
        if (itemAttributesEo != null) {
            itemChangeApplyDto.setAttrs(itemAttributesEo.getAttrs());
            itemChangeApplyDto.setSearchAttrs(itemAttributesEo.getSearchAttrs());
        }
        if (CollectionUtils.isNotEmpty(tagIdList = this.queryTagId(itemEo.getId(), null, itemEo.getInstanceId(), itemEo.getTenantId()))) {
            itemChangeApplyDto.setTags(tagIdList);
        }
        List<ItemPropRelationReqDto> itemPropRelationReqDtoList = this.queryItemProp(itemEo.getId(), itemEo.getSellerId(), itemEo.getInstanceId(), itemEo.getTenantId());
        itemChangeApplyDto.setItemPropRelationReqDtos(itemPropRelationReqDtoList);
        return itemChangeApplyDto;
    }

    private List<ItemBundleReqDto> queryItemBundle(Long itemId, Integer type, Long instanceId, Long tenantId) {
        ArrayList<ItemBundleReqDto> itemBundleReqDtoList = new ArrayList<ItemBundleReqDto>();
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        itemSkuEo.setItemId(itemId);
        itemSkuEo.setInstanceId(instanceId);
        itemSkuEo.setTenantId(tenantId);
        itemSkuEo.setOrderBy("id");
        List itemSkuEoList = this.itemSkuDas.select((BaseEo)itemSkuEo);
        if (CollectionUtils.isNotEmpty((Collection)itemSkuEoList)) {
            for (ItemSkuEo skuEo : itemSkuEoList) {
                ItemBundleReqDto itemBundleReqDto = new ItemBundleReqDto();
                DtoHelper.eo2Dto((BaseEo)skuEo, (BaseVo)itemBundleReqDto);
                if (ItemType.BUNDLE.getIndex().equals(type)) {
                    List<BundleItemReqDto> bundleItemReqDtoList = this.queryBundleItem(itemBundleReqDto.getItemId(), itemBundleReqDto.getId(), itemBundleReqDto.getInstanceId(), itemBundleReqDto.getTenantId());
                    itemBundleReqDto.setBundleItemDtos(bundleItemReqDtoList);
                }
                List<ItemPriceReqDto> itemPriceReqDtoList = this.queryItemPrice(itemBundleReqDto.getItemId(), itemBundleReqDto.getId(), itemBundleReqDto.getInstanceId(), itemBundleReqDto.getTenantId());
                itemBundleReqDto.setPrices(itemPriceReqDtoList);
                List<ItemMediasReqDto> itemMediasReqDtoList = this.queryItemMedias(itemBundleReqDto.getItemId(), itemBundleReqDto.getId(), itemBundleReqDto.getInstanceId(), itemBundleReqDto.getTenantId());
                itemBundleReqDto.setMedias(itemMediasReqDtoList);
                List<Long> tagIdList = this.queryTagId(itemBundleReqDto.getItemId(), itemBundleReqDto.getId(), itemBundleReqDto.getInstanceId(), itemBundleReqDto.getTenantId());
                if (CollectionUtils.isNotEmpty(tagIdList)) {
                    itemBundleReqDto.setTags(tagIdList);
                }
                itemBundleReqDtoList.add(itemBundleReqDto);
            }
        }
        return itemBundleReqDtoList;
    }

    private List<BundleItemReqDto> queryBundleItem(Long itemId, Long skuId, Long instanceId, Long tenantId) {
        ArrayList<BundleItemReqDto> bundleItemReqDtoList = new ArrayList<BundleItemReqDto>();
        ItemBundleRelationEo itemBundleRelationEo = new ItemBundleRelationEo();
        itemBundleRelationEo.setItemId(itemId);
        itemBundleRelationEo.setSkuId(skuId);
        itemBundleRelationEo.setTenantId(tenantId);
        itemBundleRelationEo.setInstanceId(instanceId);
        List itemBundleRelationEoList = this.itemBundleRelationDas.select((BaseEo)itemBundleRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)itemBundleRelationEoList)) {
            for (ItemBundleRelationEo bundleRelationEo : itemBundleRelationEoList) {
                BundleItemReqDto bundleItemReqDto = new BundleItemReqDto();
                DtoHelper.eo2Dto((BaseEo)bundleRelationEo, (BaseVo)bundleItemReqDto);
                bundleItemReqDtoList.add(bundleItemReqDto);
            }
        }
        return bundleItemReqDtoList;
    }

    private List<ItemPriceReqDto> queryItemPrice(Long itemId, Long skuId, Long instanceId, Long tenantId) {
        ArrayList<ItemPriceReqDto> itemPriceReqDtoList = new ArrayList<ItemPriceReqDto>();
        ItemPriceEo itemPriceEo = new ItemPriceEo();
        itemPriceEo.setItemId(itemId);
        if (skuId != null) {
            itemPriceEo.setSkuId(skuId);
        } else {
            itemPriceEo.setSqlFilters(this.getSqlFilter());
        }
        itemPriceEo.setInstanceId(instanceId);
        itemPriceEo.setTenantId(tenantId);
        List itemPriceEoList = this.itemPriceDas.select((BaseEo)itemPriceEo);
        if (CollectionUtils.isNotEmpty((Collection)itemPriceEoList)) {
            for (ItemPriceEo priceEo : itemPriceEoList) {
                ItemPriceReqDto itemPriceReqDto = new ItemPriceReqDto();
                DtoHelper.eo2Dto((BaseEo)priceEo, (BaseVo)itemPriceReqDto);
                itemPriceReqDtoList.add(itemPriceReqDto);
            }
        }
        return itemPriceReqDtoList;
    }

    private List<ItemMediasReqDto> queryItemMedias(Long itemId, Long skuId, Long instanceId, Long tenantId) {
        ArrayList<ItemMediasReqDto> itemMediasReqDtoList = new ArrayList<ItemMediasReqDto>();
        ItemMediasEo itemMediasEo = new ItemMediasEo();
        itemMediasEo.setItemId(itemId);
        itemMediasEo.setOrderBy("id");
        if (skuId != null) {
            itemMediasEo.setSkuId(skuId);
        } else {
            itemMediasEo.setSqlFilters(this.getSqlFilter());
        }
        itemMediasEo.setInstanceId(instanceId);
        itemMediasEo.setTenantId(tenantId);
        List itemMediasEoList = this.itemMediasDas.select((BaseEo)itemMediasEo);
        if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
            for (ItemMediasEo mediasEo : itemMediasEoList) {
                ItemMediasReqDto itemMediasReqDto = new ItemMediasReqDto();
                DtoHelper.eo2Dto((BaseEo)mediasEo, (BaseVo)itemMediasReqDto);
                itemMediasReqDtoList.add(itemMediasReqDto);
            }
        }
        return itemMediasReqDtoList;
    }

    private List<Long> queryTagId(Long itemId, Long skuId, Long instanceId, Long tenantId) {
        ArrayList<Long> tagIdList = new ArrayList<Long>();
        ItemTagRelationEo itemTagRelationEo = new ItemTagRelationEo();
        itemTagRelationEo.setItemId(itemId);
        itemTagRelationEo.setOrderBy("id");
        if (skuId != null) {
            itemTagRelationEo.setSkuId(skuId);
        } else {
            itemTagRelationEo.setSqlFilters(this.getSqlFilter());
        }
        itemTagRelationEo.setInstanceId(instanceId);
        itemTagRelationEo.setTenantId(tenantId);
        List itemTagRelationEoList = this.itemTagRelationDas.select((BaseEo)itemTagRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)itemTagRelationEoList)) {
            for (ItemTagRelationEo tagRelationEo : itemTagRelationEoList) {
                tagIdList.add(tagRelationEo.getTagId());
            }
        }
        return tagIdList;
    }

    private ItemAttributesEo queryItemAttribute(Long itemId, Long instanceId, Long tenantId) {
        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
        itemAttributesEo.setItemId(itemId);
        itemAttributesEo.setInstanceId(instanceId);
        itemAttributesEo.setTenantId(tenantId);
        itemAttributesEo = (ItemAttributesEo)this.itemAttributesDas.selectOne((BaseEo)itemAttributesEo);
        return itemAttributesEo;
    }

    private List<ItemPropRelationReqDto> queryItemProp(Long itemId, Long sellerId, Long instanceId, Long tenantId) {
        ArrayList<ItemPropRelationReqDto> itemPropRelationReqDtoList = new ArrayList<ItemPropRelationReqDto>();
        ItemPropRelationEo itemPropRelationEo = new ItemPropRelationEo();
        itemPropRelationEo.setItemId(itemId);
        itemPropRelationEo.setSellerId(sellerId);
        itemPropRelationEo.setInstanceId(instanceId);
        itemPropRelationEo.setTenantId(tenantId);
        itemPropRelationEo.setOrderBy("id");
        List itemPropRelationEoList = this.itemPropRelationDas.select((BaseEo)itemPropRelationEo);
        if (CollectionUtils.isNotEmpty((Collection)itemPropRelationEoList)) {
            for (ItemPropRelationEo propRelationEo : itemPropRelationEoList) {
                ItemPropRelationReqDto itemPropRelationReqDto = new ItemPropRelationReqDto();
                DtoHelper.eo2Dto((BaseEo)propRelationEo, (BaseVo)itemPropRelationReqDto);
                itemPropRelationReqDtoList.add(itemPropRelationReqDto);
            }
        }
        return itemPropRelationReqDtoList;
    }

    private List<SqlFilter> getSqlFilter() {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.isNull((String)"sku_id"));
        return sqlFilterList;
    }
}

