/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.query.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailBaseInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemAttributesDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdDirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.dto.request.ItemExportQueryReqDto;
import com.yx.tcbj.center.api.dto.request.ItemPricePageReqDto;
import com.yx.tcbj.center.api.dto.request.ItemShopQueryReqDto;
import com.yx.tcbj.center.api.dto.request.ItemSkuExcludeReqDto;
import com.yx.tcbj.center.api.dto.request.ItemSkuInfoReqDto;
import com.yx.tcbj.center.api.dto.response.ItemExportQueryRespDto;
import com.yx.tcbj.center.api.dto.response.ItemPricePageRespDto;
import com.yx.tcbj.center.api.dto.response.ItemSkuExcludeRespDto;
import com.yx.tcbj.center.api.dto.response.SpecsPriceRespDto;
import com.yx.tcbj.center.biz.service.query.IItemCenterQueryService;
import com.yx.tcbj.center.dao.ItemExtVo;
import com.yx.tcbj.center.dao.das.ItemExtDas;
import com.yx.tcbj.center.dao.das.SellerSkuPriceDas;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ItemCenterQueryServiceImpl
implements IItemCenterQueryService {
    private static final Logger log = LoggerFactory.getLogger(ItemCenterQueryServiceImpl.class);
    @Resource
    private ItemDas itemDas;
    @Resource
    private DirDas dirDas;
    @Resource
    private ItemAttributesDas itemAttributesDas;
    @Resource
    private SellerSkuPriceDas sellerSkuPriceDas;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IDirService dirService;
    @Resource
    private ItemPriceDas itemPriceDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemAuthDas itemAuthDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemExtDas itemExtDas;
    @Resource
    private IContext context;
    @Resource
    private HttpServletRequest request;
    @Resource
    private ItemAuthService itemAuthService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    private static final Logger logger = LoggerFactory.getLogger(ItemCenterQueryServiceImpl.class);

    @Override
    public ItemRespDto queryByLongCode(String longCode) {
        ItemEo itemEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"long_code", (Object)longCode)).one();
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        return itemRespDto;
    }

    @Override
    public List<ItemRespDto> queryByLongCodeList(List<String> longCodeList) {
        List list = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"long_code", longCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ItemRespDto>(0);
        }
        ArrayList<ItemRespDto> itemRespDtoList = new ArrayList<ItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, itemRespDtoList, ItemRespDto.class);
        return itemRespDtoList;
    }

    @Override
    public PageInfo<ItemPricePageRespDto> queryPriceByPage(ItemPricePageReqDto filter) {
        if (CollectionUtils.isNotEmpty((Collection)filter.getDirIds())) {
            List rootIds;
            List rootEos;
            DirEo rootEo;
            HashSet dirIds = new HashSet();
            if (filter.getDirIds().size() == 2) {
                DirEo parentEo = new DirEo();
                parentEo.setId((Long)filter.getDirIds().get(1));
                List parentEoEos = this.dirDas.select((BaseEo)parentEo);
                if (CollectionUtils.isNotEmpty((Collection)parentEoEos)) {
                    List parentIds = parentEoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(parentIds);
                }
            } else if (filter.getDirIds().size() == 1) {
                rootEo = new DirEo();
                rootEo.setParentId((Long)filter.getDirIds().get(0));
                rootEos = this.dirDas.select((BaseEo)rootEo);
                if (CollectionUtils.isNotEmpty((Collection)rootEos)) {
                    rootIds = rootEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(rootIds);
                }
            } else {
                rootEo = new DirEo();
                rootEo.setRootId((Long)filter.getDirIds().get(0));
                rootEos = this.dirDas.select((BaseEo)rootEo);
                if (CollectionUtils.isNotEmpty((Collection)rootEos)) {
                    rootIds = rootEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(rootIds);
                }
                DirEo parentEo = new DirEo();
                parentEo.setParentId((Long)filter.getDirIds().get(0));
                List parentEoEos = this.dirDas.select((BaseEo)parentEo);
                if (CollectionUtils.isNotEmpty((Collection)parentEoEos)) {
                    List parentIds = parentEoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    dirIds.addAll(parentIds);
                }
            }
            filter.getDirIds().addAll(dirIds);
        }
        if (Objects.isNull(filter.getPageFlag()) || filter.getPageFlag().equals(0)) {
            PageHelper.startPage((int)filter.getPageNum(), (int)filter.getPageSize());
        }
        PageInfo eoPageInfo = this.sellerSkuPriceDas.queryPriceByPage(filter);
        log.info("========>:{}", (Object)eoPageInfo);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemPricePageRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List dirIds = dtoList.stream().map(ItemPricePageRespDto::getDirId).distinct().collect(Collectors.toList());
            List dirLevels = new ArrayList();
            if (CollectionUtils.isNotEmpty(dirIds)) {
                dirLevels = this.directoryItemService.queryDirLevels(dirIds);
            }
            for (ItemPricePageRespDto dto : dtoList) {
                ArrayList<SpecsPriceRespDto> specsPriceRespDtos = new ArrayList<SpecsPriceRespDto>();
                if (StringUtils.isNotEmpty((String)dto.getSkuIds())) {
                    List<String> skuIdList = Arrays.asList(dto.getSkuIds().split(","));
                    List<String> arrtList = Arrays.asList(dto.getAttr().split(","));
                    if (dto.getPrice() != null && dto.getSupplyPrice() != null) {
                        List<String> priceList = Arrays.asList(dto.getPrice().split(","));
                        List<String> supplyPriceList = Arrays.asList(dto.getSupplyPrice().split(","));
                        if (skuIdList.size() == arrtList.size() && skuIdList.size() == priceList.size() && skuIdList.size() == supplyPriceList.size()) {
                            for (int i = 0; i < skuIdList.size(); ++i) {
                                SpecsPriceRespDto specsPriceRespDto = new SpecsPriceRespDto();
                                specsPriceRespDto.setSkuId(Long.valueOf(skuIdList.get(i)));
                                specsPriceRespDto.setSpecs(arrtList.get(i));
                                specsPriceRespDto.setRetailPrice(new BigDecimal(priceList.get(i)));
                                specsPriceRespDto.setSupplyPrice(new BigDecimal(supplyPriceList.get(i)));
                                specsPriceRespDtos.add(specsPriceRespDto);
                            }
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(specsPriceRespDtos)) {
                    TreeSet<SpecsPriceRespDto> specs = new TreeSet<SpecsPriceRespDto>((o1, o2) -> o1.getSkuId().compareTo(o2.getSkuId()));
                    specs.addAll(specsPriceRespDtos);
                    ArrayList specsDtos = new ArrayList(specs);
                    dto.setSpecsPriceRespDtos(specsDtos);
                } else {
                    dto.setSpecsPriceRespDtos(specsPriceRespDtos);
                }
                if (!Objects.nonNull(dto.getDirId())) continue;
                for (List dirLevel : dirLevels) {
                    if (!dto.getDirId().equals(((DirectoryItemRespDto)dirLevel.get(dirLevel.size() - 1)).getId())) continue;
                    ArrayList<String> dirName = new ArrayList<String>();
                    dto.setDirectoryItemRespDtos(dirLevel);
                    for (int i = 0; i < dirLevel.size(); ++i) {
                        if (i <= 0) continue;
                        dirName.add(((DirectoryItemRespDto)dirLevel.get(i)).getName());
                    }
                    dto.setDirNameList(dirName);
                    log.info("dirName===>:{}", dirName);
                }
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ItemSkuExcludeRespDto> findItemSkuExclude(ItemSkuExcludeReqDto itemSkuExcludeReqDto) {
        List itemPriceEos;
        if (CollectionUtils.isNotEmpty((Collection)itemSkuExcludeReqDto.getDirIds())) {
            List dirIdList = this.dirService.getLinkAndChildDirIdList(itemSkuExcludeReqDto.getDirIds(), itemSkuExcludeReqDto.getInstanceId(), itemSkuExcludeReqDto.getTenantId());
            if (CollectionUtils.isEmpty((Collection)dirIdList)) {
                return null;
            }
            itemSkuExcludeReqDto.setDirIds(dirIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)itemSkuExcludeReqDto.getBackDirIds())) {
            List backDirIds = this.dirService.getLinkAndChildDirIdList(itemSkuExcludeReqDto.getBackDirIds(), itemSkuExcludeReqDto.getInstanceId(), itemSkuExcludeReqDto.getTenantId());
            if (CollectionUtils.isEmpty((Collection)backDirIds)) {
                return null;
            }
            itemSkuExcludeReqDto.setBackDirIds(backDirIds);
        }
        List<ItemExtVo> itemEoList = this.pageItemSkuExclude(itemSkuExcludeReqDto);
        ArrayList<ItemSkuExcludeRespDto> managementBlockRespDtos = new ArrayList<ItemSkuExcludeRespDto>();
        Set itemIds = itemEoList.stream().map(ItemVo::getItemId).collect(Collectors.toSet());
        List dirItemRelationEos = this.dirItemRelationDas.selectByItemIdsAndDirType((List)Lists.newArrayList(itemIds), "front");
        Map groupDirItemEo = dirItemRelationEos.stream().collect(Collectors.groupingBy(StdDirItemRelationEo::getItemId, Collectors.toList()));
        HashSet allFrontDirIdSet = Sets.newHashSet();
        HashMap<Long, ArrayList> frontDirIdsMap = new HashMap<Long, ArrayList>();
        for (Map.Entry groupDirItemEntry : groupDirItemEo.entrySet()) {
            Long key = groupDirItemEntry.getKey();
            itemPriceEos = groupDirItemEntry.getValue();
            HashSet frontDirIdSet = Sets.newHashSet();
            for (DirItemRelationEo dirItemRelationEo : itemPriceEos) {
                frontDirIdSet.add(dirItemRelationEo.getDirId());
            }
            allFrontDirIdSet.addAll(frontDirIdSet);
            frontDirIdsMap.put(key, Lists.newArrayList((Iterable)frontDirIdSet));
        }
        List frontDirEos = this.dirDas.selectByIds((List)Lists.newArrayList((Iterable)allFrontDirIdSet));
        Map<Long, String> frontDirNameMap = frontDirEos.stream().collect(Collectors.toMap(BaseEo::getId, StdDirEo::getName, (e1, e2) -> e1));
        List skuIds = itemEoList.stream().filter(bean -> null != bean.getSkuId()).map(ItemVo::getSkuId).collect(Collectors.toList());
        itemPriceEos = this.itemPriceDas.selectBySkuIds(skuIds);
        Map group = itemPriceEos.stream().collect(Collectors.groupingBy(StdItemPriceEo::getSkuId, Collectors.toList()));
        List collectDirId = itemEoList.stream().filter(bean -> null != bean.getDirId()).map(ItemVo::getDirId).collect(Collectors.toList());
        List dirEos = this.dirDas.selectByIds(collectDirId);
        Map groupDirEo = dirEos.stream().collect(Collectors.groupingBy(BaseEo::getId, Collectors.toList()));
        Iterator<ItemExtVo> var21 = itemEoList.iterator();
        while (true) {
            List frontDirIds;
            if (!var21.hasNext()) {
                PageInfo result = new PageInfo();
                CubeBeanUtils.copyProperties((Object)result, (Object)new PageInfo(itemEoList), (String[])new String[]{"list", "navigatepageNums"});
                result.setList(managementBlockRespDtos);
                return result;
            }
            ItemExtVo itemVo = var21.next();
            ItemSkuExcludeRespDto newOne = new ItemSkuExcludeRespDto();
            BeanUtils.copyProperties((Object)itemVo, (Object)newOne);
            newOne.setPath(this.getMainPic(itemVo.getItemId()));
            newOne.setShopId(itemVo.getShopId());
            managementBlockRespDtos.add(newOne);
            List itemPriceEos1 = group.get(itemVo.getSkuId());
            List selectDirEo = groupDirEo.get(itemVo.getDirId());
            if (!CollectionUtils.isEmpty(itemPriceEos1)) {
                Map collect = itemPriceEos1.stream().collect(Collectors.groupingBy(StdItemPriceEo::getPriceType, Collectors.toList()));
                ShelfEo selectItem = new ShelfEo();
                selectItem.setOrderByDesc("updateTime");
                selectItem.setSkuId(itemVo.getSkuId());
                selectItem.setStatus(Integer.valueOf(1));
                selectItem.setShopId(itemSkuExcludeReqDto.getShopId());
                selectItem.setDr(0);
                List shelfEos = this.shelfDas.selectList((BaseEo)selectItem);
                List price = collect.get("PRICE");
                newOne.setRetailPrice(CollectionUtils.isEmpty((Collection)shelfEos) ? null : ((ShelfEo)shelfEos.get(0)).getPrice());
                newOne.setSellPrice(CollectionUtils.isEmpty(price) ? null : ((ItemPriceEo)price.get(0)).getPrice());
            }
            if (!CollectionUtils.isEmpty(selectDirEo)) {
                newOne.setDirName(((DirEo)selectDirEo.get(0)).getName());
            }
            if (!CollectionUtils.isNotEmpty((Collection)(frontDirIds = (List)frontDirIdsMap.get(itemVo.getItemId())))) continue;
            newOne.setFrontDirIds(frontDirIds);
            ArrayList frontDirNames = Lists.newArrayList();
            for (Long frontDirId : frontDirIds) {
                String frontDirName = frontDirNameMap.get(frontDirId);
                frontDirNames.add(frontDirName);
            }
            newOne.setFrontDirNames((List)frontDirNames);
        }
    }

    @Override
    public List<ItemDetailBaseInfoRespDto> queryShopItemList(ItemShopQueryReqDto itemShopQueryReqDto) {
        ArrayList itemDetailBaseInfoRespDtoList = Lists.newArrayList();
        List itemCodes = itemShopQueryReqDto.getItemCodes();
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemCodes), (String)"100003", (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        itemCodes.removeAll(Collections.singleton(null));
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemCodes), (String)"100004", (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ItemEo itemEo = new ItemEo();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemEo).in(StdItemEo::getCode, (Collection)itemCodes);
        List itemEoList = this.itemDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemEoList)) {
            return itemDetailBaseInfoRespDtoList;
        }
        List itemIdList = itemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        LambdaQueryWrapper skuQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemSkuEo).in(StdItemSkuEo::getItemId, itemIdList);
        List itemSkuEoList = this.itemSkuDas.getMapper().selectList((Wrapper)skuQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)itemSkuEoList)) {
            return itemDetailBaseInfoRespDtoList;
        }
        List skuIdList = itemSkuEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        ItemAuthEo itemAuthEo = new ItemAuthEo();
        LambdaQueryWrapper skuAuthQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemAuthEo).in(ItemAuthEo::getBusinessId, skuIdList)).eq(ItemAuthEo::getTargetId, (Object)itemShopQueryReqDto.getShopId())).eq(ItemAuthEo::getTargetType, (Object)itemShopQueryReqDto.getTargetType());
        List itemAuthEoList = this.itemAuthDas.getMapper().selectList((Wrapper)skuAuthQueryWrapper);
        ItemMediasEo itemMediasEo = new ItemMediasEo();
        LambdaQueryWrapper itemMediasEoQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper((Object)itemMediasEo).in(StdItemMediasEo::getItemId, itemIdList);
        List itemMediasEoList = this.itemMediasDas.getMapper().selectList((Wrapper)itemMediasEoQueryWrapper);
        Map<Long, List<ItemMediasRespDto>> itemMediaListMap = null;
        if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
            ArrayList itemMediasList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemMediasEoList, (Collection)itemMediasList, ItemMediasRespDto.class);
            itemMediaListMap = itemMediasList.stream().collect(Collectors.groupingBy(ItemMediasRespDto::getItemId));
        }
        List businessIdList = itemAuthEoList.stream().map(ItemAuthEo::getBusinessId).collect(Collectors.toList());
        Map itemEoMap = itemEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map itemSkuMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Long, List<ItemMediasRespDto>> finalItemMediaListMap = itemMediaListMap;
        businessIdList.stream().distinct().forEach(businessId -> {
            ItemEo item;
            ItemSkuEo skuEo = (ItemSkuEo)itemSkuMap.get(businessId);
            if (skuEo != null && (item = (ItemEo)itemEoMap.get(skuEo.getItemId())) != null) {
                ItemDetailBaseInfoRespDto itemDetailBaseInfoRespDto = new ItemDetailBaseInfoRespDto();
                BeanUtils.copyProperties((Object)item, (Object)itemDetailBaseInfoRespDto);
                itemDetailBaseInfoRespDto.setAttrs(skuEo.getAttr());
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("subType", item.getSubType());
                itemDetailBaseInfoRespDto.setExtFields(map);
                if (finalItemMediaListMap != null) {
                    itemDetailBaseInfoRespDto.setItemMediasList((List)finalItemMediaListMap.get(item.getId()));
                }
                ArrayList itemSkuList = Lists.newArrayList();
                ItemSkuInfoRespDto itemSkuInfoRespDto = new ItemSkuInfoRespDto();
                BeanUtils.copyProperties((Object)skuEo, (Object)itemSkuInfoRespDto);
                itemSkuList.add(itemSkuInfoRespDto);
                itemDetailBaseInfoRespDto.setItemSkuList((List)itemSkuList);
                itemDetailBaseInfoRespDtoList.add(itemDetailBaseInfoRespDto);
            }
        });
        return itemDetailBaseInfoRespDtoList;
    }

    private List<ItemExtVo> pageItemSkuExclude(ItemSkuExcludeReqDto itemSkuExcludeReqDto) {
        PageHelper.startPage((int)(itemSkuExcludeReqDto.getPageNum() == null ? 1 : itemSkuExcludeReqDto.getPageNum()), (int)(itemSkuExcludeReqDto.getPageSize() == null ? 10 : itemSkuExcludeReqDto.getPageSize()));
        return this.itemExtDas.pageItemSkuExclude(itemSkuExcludeReqDto);
    }

    private String getMainPic(Long itemId) {
        List itemMediasEoList = this.itemMediasDas.selectByItemId(itemId);
        return CollectionUtils.isNotEmpty((Collection)itemMediasEoList) ? ((ItemMediasEo)itemMediasEoList.get(0)).getPath1() : null;
    }

    @Override
    public List<com.yx.tcbj.center.api.dto.response.ItemSkuInfoRespDto> queryItemSkuInfo(ItemSkuInfoReqDto reqDto) {
        List itemEos;
        ArrayList<com.yx.tcbj.center.api.dto.response.ItemSkuInfoRespDto> respDtos = new ArrayList<com.yx.tcbj.center.api.dto.response.ItemSkuInfoRespDto>();
        ItemEo itemEo = new ItemEo();
        if (Objects.nonNull(reqDto.getOrganizationId())) {
            itemEo.setOrganizationId(reqDto.getOrganizationId());
        }
        if (Objects.nonNull(reqDto.getStatus())) {
            itemEo.setStatus(reqDto.getStatus());
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getItemCodes())) {
            itemEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"code", (Object)reqDto.getItemCodes())));
        }
        if (CollectionUtil.isEmpty((Collection)(itemEos = this.itemDas.select((BaseEo)itemEo)))) {
            return respDtos;
        }
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        itemSkuEo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"item_id", itemEos.stream().map(BaseEo::getId).collect(Collectors.toList()))));
        List itemSkuEos = this.itemSkuDas.select((BaseEo)itemSkuEo);
        if (CollectionUtils.isNotEmpty((Collection)itemSkuEos)) {
            for (ItemSkuEo itemSku : itemSkuEos) {
                for (ItemEo item : itemEos) {
                    if (!Objects.nonNull(itemSku) || !Objects.nonNull(item) || !Objects.nonNull(itemSku.getItemId()) || !Objects.nonNull(item.getId()) || itemSku.getItemId().longValue() != item.getId().longValue()) continue;
                    com.yx.tcbj.center.api.dto.response.ItemSkuInfoRespDto respDto = new com.yx.tcbj.center.api.dto.response.ItemSkuInfoRespDto();
                    respDto.setItemCode(item.getCode());
                    respDto.setItemName(item.getName());
                    respDto.setSkuId(itemSku.getId());
                    respDto.setOrganizationId(item.getOrganizationId());
                    respDto.setStatus(item.getStatus());
                    respDtos.add(respDto);
                }
            }
        }
        return respDtos;
    }

    @Override
    public PageInfo<ItemExportQueryRespDto> queryExportPage(ItemExportQueryReqDto itemListQueryReqDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u4e0a\u4e0b\u67b6\u5217\u8868\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemListQueryReqDto));
        PageInfo respDtoPageInfo = new PageInfo();
        ItemShelfQueryReqDto itemShelfQueryReqDto = new ItemShelfQueryReqDto();
        CubeBeanUtils.copyProperties((Object)itemShelfQueryReqDto, (Object)itemListQueryReqDto, (String[])new String[0]);
        itemShelfQueryReqDto.setItemStatus(itemListQueryReqDto.getStatus());
        itemShelfQueryReqDto.setBusType(itemListQueryReqDto.getBusType());
        if (Objects.nonNull(itemListQueryReqDto.getBrandId())) {
            itemShelfQueryReqDto.setBrandIds((List)Lists.newArrayList((Object[])new Long[]{itemListQueryReqDto.getBrandId()}));
        }
        if (Objects.nonNull(itemListQueryReqDto.getBackDirId())) {
            itemShelfQueryReqDto.setDirIds((List)Lists.newArrayList((Object[])new Long[]{itemListQueryReqDto.getBackDirId()}));
        }
        if (Objects.nonNull(itemListQueryReqDto.getChannel())) {
            if (itemListQueryReqDto.getChannel() == 1) {
                logger.info("\u54c1\u724c\u65b9...");
                SellerToBQueryReqDto sellerToBQueryReqDto = new SellerToBQueryReqDto();
                sellerToBQueryReqDto.setPageNum(1);
                sellerToBQueryReqDto.setPageSize(Integer.MAX_VALUE);
                logger.info("\u5f00\u59cb\u67e5\u8be2\u54c1\u724c\u65b9\u5546\u5bb6\u5217\u8868\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)sellerToBQueryReqDto));
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.queryPage(sellerToBQueryReqDto));
                logger.info("\u7ed3\u675f\u67e5\u8be2\u54c1\u724c\u65b9\u5546\u5bb6\u5217\u8868\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)pageInfo));
                if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                    logger.info("\u6ca1\u67e5\u8be2\u5230\u54c1\u724c\u65b9\u5546\u5bb6\uff0c\u8fd4\u56de\u7a7a...");
                    return respDtoPageInfo;
                }
                List sellerIds = pageInfo.getList().stream().map(SellerToBListRespDto::getId).collect(Collectors.toList());
                itemShelfQueryReqDto.setSellerIds(sellerIds);
            } else if (itemListQueryReqDto.getChannel() == 2) {
                logger.info("\u5927B\u7aef...");
                Long currentUserOrgId = itemListQueryReqDto.getOrganizationId();
                SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(currentUserOrgId));
                logger.info("\u67e5\u8be2\u5927B\u7aef\u5546\u5bb6\u5217\u8868\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)sellerRespDto));
                if (Objects.isNull(sellerRespDto)) {
                    logger.info("\u6ca1\u67e5\u8be2\u5230\u5927B\u7aef\u5546\u5bb6\uff0c\u8fd4\u56de\u7a7a...");
                    return respDtoPageInfo;
                }
                itemShelfQueryReqDto.setSellerId(sellerRespDto.getId());
            }
        }
        logger.info("\u5f00\u59cb\u67e5\u8be2\u5546\u54c1\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemShelfQueryReqDto));
        RestResponse restResponse = this.itemQueryApi.queryShelfItemByPage(itemShelfQueryReqDto, itemListQueryReqDto.getPageNum(), itemListQueryReqDto.getPageSize());
        logger.info("\u7ed3\u675f\u67e5\u8be2\u5546\u54c1\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        if ("0".equals(restResponse.getResultCode()) && Objects.nonNull(restResponse.getData()) && CollectionUtils.isNotEmpty((Collection)((PageInfo)restResponse.getData()).getList())) {
            PageInfo shelfQuery = (PageInfo)restResponse.getData();
            CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)shelfQuery, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList<ItemExportQueryRespDto> itemExportRespDtos = new ArrayList<ItemExportQueryRespDto>();
            if (Objects.nonNull(shelfQuery) && CollectionUtils.isNotEmpty((Collection)shelfQuery.getList())) {
                for (ItemShelfQueryRespDto respDto : shelfQuery.getList()) {
                    ItemExportQueryRespDto itemExportDto = new ItemExportQueryRespDto();
                    BeanUtils.copyProperties((Object)respDto, (Object)itemExportDto);
                    if (CollectionUtils.isNotEmpty((Collection)respDto.getSkuList())) {
                        ArrayList skuRespDtos = new ArrayList();
                        CubeBeanUtils.copyCollection(skuRespDtos, (Collection)respDto.getSkuList(), ItemSkuRespDto.class);
                        itemExportDto.setSkus(skuRespDtos);
                    }
                    itemExportRespDtos.add(itemExportDto);
                }
            }
            if (CollectionUtils.isNotEmpty(itemExportRespDtos)) {
                String itemIds;
                RestResponse itemRespDtos;
                Set shopIdSet = shelfQuery.getList().stream().map(ItemShelfQueryRespDto::getShopId).collect(Collectors.toSet());
                RestResponse response = this.shopQueryApi.queryBaseListByIds(shopIdSet);
                if ("0".equals(response.getResultCode()) && Objects.nonNull(response.getData())) {
                    Map<Long, String> shopMap = ((List)response.getData()).stream().collect(Collectors.toMap(ShopBaseDto::getId, ShopBaseDto::getName));
                    itemExportRespDtos.forEach(dto -> dto.setShopName((String)shopMap.get(dto.getShopId())));
                }
                if ("0".equals((itemRespDtos = this.itemQueryApi.queryByItemIds(itemIds = itemExportRespDtos.stream().map(ItemExportQueryRespDto::getItemId).map(String::valueOf).collect(Collectors.joining(",")))).getResultCode()) && Objects.nonNull(itemRespDtos.getData())) {
                    for (ItemExportQueryRespDto exportDto : itemExportRespDtos) {
                        for (ItemRespDto itemDto : (List)itemRespDtos.getData()) {
                            if (!Objects.nonNull(exportDto) || !Objects.nonNull(exportDto.getItemId()) || !Objects.nonNull(itemDto) || !Objects.nonNull(itemDto.getId()) || exportDto.getItemId().longValue() != itemDto.getId().longValue()) continue;
                            exportDto.setLongCode(itemDto.getLongCode());
                        }
                    }
                }
                this.setExternalCode(itemExportRespDtos);
                respDtoPageInfo.setList(itemExportRespDtos);
            }
        }
        logger.info("\u6700\u7ec8\u8fd4\u56de\u7684\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDtoPageInfo));
        return respDtoPageInfo;
    }

    private void setExternalCode(List<ItemExportQueryRespDto> itemListRespDtoList) {
        if (CollectionUtils.isEmpty(itemListRespDtoList)) {
            return;
        }
        for (ItemExportQueryRespDto itemListRespDto : itemListRespDtoList) {
            List list;
            ItemAuthReqDto dto = new ItemAuthReqDto();
            dto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
            dto.setTargetId(itemListRespDto.getShopId());
            dto.setBusinessType(ItemAuthEnum.BusinessType.SKU.getCode());
            if (CollectionUtils.isNotEmpty((Collection)itemListRespDto.getSkus())) {
                dto.setBusinessIdList(itemListRespDto.getSkus().stream().map(ItemSkuRespDto::getId).filter(Objects::nonNull).collect(Collectors.toList()));
            }
            if (!ObjectUtils.isNotEmpty((Object)(list = this.itemAuthService.list(dto)))) continue;
            itemListRespDto.setExternalCode(((ItemAuthRespDto)list.get(0)).getExternalCode());
        }
    }
}

