/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemExtendReqDto;
import com.yx.tcbj.center.api.dto.response.ItemExtendRespDto;
import com.yx.tcbj.center.biz.service.IItemExtendService;
import com.yx.tcbj.center.biz.service.IPcpItemService;
import com.yx.tcbj.center.dao.das.ItemExtendDas;
import com.yx.tcbj.center.dao.eo.ItemExtendEo;
import com.yx.tcbj.center.dao.mapper.ItemExtendMapper;
import icu.mhb.mybatisplus.plugln.base.service.impl.JoinServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemExtendServiceImpl
extends JoinServiceImpl<ItemExtendMapper, ItemExtendEo>
implements IItemExtendService {
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IPcpItemService pcpItemService;

    @Override
    public Long addItemExtend(ItemExtendReqDto addReqDto) {
        long id;
        ItemExtendEo queryEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getItemCode());
        if (queryEo != null && queryEo.getId() != null) {
            addReqDto.setId(queryEo.getId());
            this.modifyItemExtend(addReqDto);
            id = queryEo.getId();
        } else {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtendEo);
            itemExtendEo.setSpecification(addReqDto.getSpecifications());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            this.pcpItemService.publishItemSyncEvent(itemExtendEo);
            id = itemExtendEo.getId();
        }
        return id;
    }

    @Override
    public void modifyItemExtend(ItemExtendReqDto modifyReqDto) {
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemExtendEo);
        itemExtendEo.setSpecification(modifyReqDto.getSpecifications());
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
        this.pcpItemService.publishItemSyncEvent(itemExtendEo);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)modifyReqDto.getItemCode());
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            return;
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
        itemExtendEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"item_code", (Object)modifyReqDto.getItemCode())}));
        this.itemExtendDas.updateSelectiveSqlFilter((BaseEo)itemExtendEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemExtend(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public List<ItemExtendRespDto> queryParam(ItemExtendReqDto reqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
            queryWrapper.eq(ItemExtendEo::getItemCode, (Object)reqDto.getItemCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List list = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ItemExtendRespDto> dtoList = new ArrayList<ItemExtendRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ItemExtendRespDto.class);
        return dtoList;
    }

    @Override
    public ItemExtendRespDto queryById(Long id) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(id);
        ItemExtendRespDto itemExtendRespDto = new ItemExtendRespDto();
        DtoHelper.eo2Dto((BaseEo)itemExtendEo, (BaseVo)itemExtendRespDto);
        return itemExtendRespDto;
    }

    @Override
    public PageInfo<ItemExtendRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemExtendReqDto itemExtendReqDto = (ItemExtendReqDto)JSON.parseObject((String)filter, ItemExtendReqDto.class);
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)itemExtendReqDto, (BaseEo)itemExtendEo);
        PageInfo eoPageInfo = this.itemExtendDas.selectPage((BaseEo)itemExtendEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemExtendRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

