/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.dao.das;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.dtyunxi.yundt.cube.center.item.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.mapper.ItemExtShelfMapper;
import com.dtyunxi.yundt.cube.center.item.dao.vo.DirCategoryRespVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.EmpowerItemReqVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.EmpowerQueryVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.OrderItemPopularRespVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ShelfListRespVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ShelfQueryReqVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ItemExtShelfDas
extends AbstractBaseDas<ShelfEo, String> {
    @Resource
    ItemExtShelfMapper itemExtShelfMapper;

    public PageInfo<ShelfListRespVo> queryShelfPage(ShelfQueryReqVo reqVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfListRespVo> shelfItemVoList = this.itemExtShelfMapper.queryShelfPage(reqVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    public PageInfo<ShelfItemVo> selectSelfItemByPage(ShelfItemVo shelfItemVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemVo> shelfItemVoList = this.itemExtShelfMapper.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    public Long selectSelfItemCount(@Param(value="shelfItemVo") ShelfItemVo shelfItemVo) {
        ItemExtShelfMapper shelfMapper = (ItemExtShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItems(shelfItemVo).size();
    }

    public List<ShelfListRespVo> countShelfItem(ShelfQueryReqVo reqVo) {
        return this.itemExtShelfMapper.countShelfItem(reqVo);
    }

    public PageInfo<ShelfListRespVo> notOnShelfItemPage(ShelfQueryReqVo reqVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfListRespVo> notOnShelfItemList = this.itemExtShelfMapper.notOnShelfItemPage(reqVo, pageNum, pageSize);
        return new PageInfo(notOnShelfItemList);
    }

    public PageInfo<EmpowerItemReqVo> queryEmpowerItemPage(EmpowerQueryVo queryVo) {
        if (queryVo.getPageNum() != null && queryVo.getPageSize() != null) {
            PageHelper.startPage((int)queryVo.getPageNum(), (int)queryVo.getPageSize());
        }
        List<EmpowerItemReqVo> itemReqVoList = this.itemExtShelfMapper.queryEmpowerItemPage(queryVo, queryVo.getPageNum(), queryVo.getPageSize());
        return new PageInfo(itemReqVoList);
    }

    public List<DirCategoryRespVo> queryParentCategorys(Long id) {
        List<Map<String, Object>> list = this.itemExtShelfMapper.queryParentCategorys(id);
        List respVoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DirCategoryRespVo>();
        }
        respVoList = JSONArray.parseArray((String)JSON.toJSONString(list), DirCategoryRespVo.class);
        return respVoList;
    }

    public List<DirCategoryRespVo> queryChildCategorys(Long id) {
        List respVoList = Lists.newArrayList();
        List<Map<String, Object>> list = this.itemExtShelfMapper.queryChildCategorys(id);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DirCategoryRespVo>();
        }
        respVoList = JSONArray.parseArray((String)JSON.toJSONString(list), DirCategoryRespVo.class);
        return respVoList;
    }

    public List<OrderItemPopularRespVo> getPopularItem(Long customerId, String shelfAddress, Integer size) {
        List<Map<String, Object>> list = this.itemExtShelfMapper.getPopularItem(customerId, shelfAddress, size);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<OrderItemPopularRespVo>();
        }
        List orderItemPopularRespVos = JSON.parseArray((String)JSON.toJSONString(list), OrderItemPopularRespVo.class);
        return orderItemPopularRespVos;
    }
}

