/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.shop.api.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.SellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.StdSellerAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.mapper.SellerAreaMapper;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.shop.api.service.ISellerExtService;
import com.yx.tcbj.center.shop.api.utils.AssertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerExtServiceImpl
implements ISellerExtService {
    private Logger logger = LoggerFactory.getLogger(SellerExtServiceImpl.class);
    @Resource
    private SellerAreaMapper sellerAreaMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSellerAreaBatch(List<SellerAreaDto> sellerAreaDtoList) {
        AssertUtil.assertNotEmpty(sellerAreaDtoList, "\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        List sellerAreaCodeList = sellerAreaDtoList.stream().map(SellerAreaDto::getAreaCode).distinct().collect(Collectors.toList());
        QueryWrapper sellerAreaQuery = new QueryWrapper();
        sellerAreaQuery.eq((Object)"seller_id", (Object)sellerAreaDtoList.get(0).getSellerId());
        sellerAreaQuery.in((Object)"area_code", sellerAreaCodeList);
        List sellerAreaEos = this.sellerAreaMapper.selectList((Wrapper)sellerAreaQuery);
        Map<Object, Object> sellerAreaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)sellerAreaEos)) {
            sellerAreaEoMap = sellerAreaEos.stream().collect(Collectors.toMap(StdSellerAreaEo::getAreaCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList addEoList = Lists.newArrayList();
        for (SellerAreaDto sellerAreaDto : sellerAreaDtoList) {
            if (sellerAreaEoMap.isEmpty() || !sellerAreaEoMap.containsKey(sellerAreaDto.getAreaCode())) {
                SellerAreaEo addEo = new SellerAreaEo();
                addEo.setSellerId(sellerAreaDto.getSellerId());
                addEo.setAreaCode(sellerAreaDto.getAreaCode());
                addEo.setAreaLevel(sellerAreaDto.getAreaLevel());
                addEoList.add(addEo);
                continue;
            }
            SellerAreaEo editEo = (SellerAreaEo)sellerAreaEoMap.get(sellerAreaDto.getAreaCode());
            editEo.setAreaLevel(sellerAreaDto.getAreaLevel());
            this.sellerAreaMapper.updateById((BaseEo)editEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)addEoList)) {
            this.sellerAreaMapper.insertBatch((List)addEoList);
        }
    }
}

