package com.yx.tcbj.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.response.DeliveryOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 厂家发货记录服务接口
*
* @author by_liusong
* @since 2022-04-21
*/
@Api(tags = {"厂家发货记录服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-center-trade-api-query-IDeliveryOrderQueryApi",
    name = "yundt-cube-center-trade",
    path = "/v1/trade",
    url = "${yundt.cube.center.trade.api:}"
)
public interface IDeliveryOrderQueryApi {

    /**
    * 根据id查询厂家发货记录
    *
    * @param id 厂家发货记录id
    * @return   厂家发货记录数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询厂家发货记录", notes = "根据id查询厂家发货记录")
    RestResponse<DeliveryOrderRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 厂家发货记录分页数据
    *
    * @param filter   厂家发货记录查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 厂家发货记录分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "厂家发货记录分页数据", notes = "根据filter查询条件查询厂家发货记录数据，filter=DeliveryOrderReqDto")
    RestResponse<PageInfo<DeliveryOrderRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
