package com.yx.tcbj.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.request.RefundDisposeConfigReqDto;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 退款处理配置服务接口
*
* @author 杰俊
* @since 2021-10-12
*/
@Api(tags = {"退款处理配置服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/refundDisposeConfig", url = "${yundt.cube.center.trade.api:}")
public interface IRefundDisposeConfigQueryApi {

    /**
    * 根据单号查询退款处理配置
    *
    * @param returnNo 单号
    * @return   退款处理配置数据
    */
    @GetMapping("/queryByNo")
    @ApiOperation(value = "根据单号查询退款处理配置", notes = "根据单号查询退款处理配置")
    RestResponse<RefundDisposeConfigRespDto> queryByNo(@RequestParam("returnNo") String returnNo);

    /**
     * 根据退款申请单号查询退款处理配置
     *
     * @param refundNo 单号
     * @return   退款处理配置数据
     */
    @GetMapping("/queryByRefundNo")
    @ApiOperation(value = "根据退款申请单号查询退款处理配置", notes = "根据退款申请单号查询退款处理配置")
    RestResponse<RefundDisposeConfigRespDto> queryByRefundNo(@RequestParam("refundNo") String refundNo);

    /**
     * 根据退款渠道查询退款单号
     *
     * @param refundChannelType 单号
     * @return   退款处理配置数据
     */
    @GetMapping("/queryByChannelType")
    @ApiOperation(value = "根据退款渠道查询退款单号", notes = "根据退款渠道查询退款单号")
    RestResponse<List<String>> queryByChannelType(@RequestParam("refundChannelType") Integer refundChannelType);

    /**
     * 根据退款申请单号查询退款处理配置
     *
     * @param returnNoList 退款单号链表
     * @return   退款处理配置数据
     */
    @PostMapping("/queryByRefundNoList")
    @ApiOperation(value = "根据退款申请单号链表查询退款处理配置", notes = "根据退款申请单号链表查询退款处理配置")
    RestResponse<List<RefundDisposeConfigRespDto>> queryByRefundNoList(@RequestBody List<String>  returnNoList);

//    /**
//    * 退款处理配置分页数据
//    *
//    * @param filter   退款处理配置查询条件
//    * @param pageNum  当前页
//    * @param pageSize 页大小
//    * @return 退款处理配置分页数据
//    */
//    @GetMapping("/page")
//    @ApiOperation(value = "退款处理配置分页数据", notes = "根据filter查询条件查询退款处理配置数据，filter=RefundDisposeConfigReqDto")
//    RestResponse<PageInfo<RefundDisposeConfigRespDto>> queryByPage(@RequestParam("filter") String filter,
//                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
//                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
