package com.yx.tcbj.center.trade.api.query;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.response.ExpressCompanyRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 物流公司信息服务接口
*
* @author by_liusong
* @since 2022-05-17
*/
@Api(tags = {"物流公司信息服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-center-trade-api-query-IExpressCompanyQueryApi",
    name = "yundt-cube-center-trade",
    path = "/v1/trade",
    url = "${yundt.cube.center.trade.api:}"
)
public interface IExpressCompanyQueryApi {

    /**
    * 根据id查询
    *
    * @param id id
    * @return   数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流公司信息", notes = "根据id查询物流公司信息")
    RestResponse<ExpressCompanyRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 分页数据
    *
    * @param filter   查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "分页数据物流公司信息", notes = "根据filter查询条件查询数据，filter=ExpressCompanyReqDto")
    RestResponse<PageInfo<ExpressCompanyRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
