package com.yx.tcbj.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.request.UpdateReturnReqDto;
import com.yx.tcbj.center.trade.api.dto.response.OrderV2025Dto;
import com.yx.tcbj.center.trade.api.dto.response.ReturnV2025Dto;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}",
        path = "/v2/return", url = "${yundt.cube.center.trade.api:}")
public interface IReturnV2Api {

    @PostMapping("/updateByTradeNo")
    @ApiOperation(value = "更新tr_return表")
    RestResponse<Void> updateByTradeNo(@RequestBody UpdateReturnReqDto reqDto);

    @PostMapping("/updateOrderByTradeNo")
    @ApiOperation(value = "更新tr_order表 订单本不该在这 但没必要单开一个api类")
    RestResponse<Void> updateOrderByTradeNo(@RequestBody OrderV2025Dto reqDto);

    @PostMapping("/queryReturnByReturnNo")
    RestResponse<ReturnV2025Dto> queryReturnByReturnNo(@RequestBody ReturnV2025Dto reqDto);

    @PostMapping("/queryOrderByOrderNo")
    RestResponse<OrderV2025Dto> queryOrderByOrderNo(@RequestBody OrderV2025Dto reqDto);
}
