package com.yx.tcbj.center.trade.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.trade.api.dto.request.RefundDisposeConfigReqDto;
import com.yx.tcbj.center.trade.api.dto.response.RefundDisposeConfigRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import javax.validation.Valid;

/**
* 退款处理配置服务接口
*
* @author 杰俊
* @since 2021-10-12
*/
@Api(tags = {"退款处理配置服务"})
@FeignClient(name = "${yundt.cube.center.trade.api.name:yundt-cube-center-trade}", path = "/v1/refundDisposeConfig", url = "${yundt.cube.center.trade.api:}")
public interface IRefundDisposeConfigApi {

    /**
    * 新增退款处理配置
    *
    * @param addReqDto 退款处理配置请求对象
    * @return 处理结果
    */
    @PostMapping("/addRefundDisposeConfig")
    @ApiOperation(value = "新增退款处理配置", notes = "新增退款处理配置")
    RestResponse<Long> addRefundDisposeConfig(@Valid @RequestBody RefundDisposeConfigReqDto addReqDto);

    /**
    * 修改退款处理配置
    *
    * @param modifyReqDto 退款处理配置请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改退款处理配置", notes = "修改退款处理配置")
    RestResponse<Void> modifyRefundDisposeConfig(@Valid @RequestBody RefundDisposeConfigReqDto modifyReqDto);
//
//    /**
//    * 删除退款处理配置
//    *
//    * @param ids        退款处理配置删除数据ID
//    * @param instanceId 实例ID
//    * @return 处理结果
//    */
//    @DeleteMapping("/{ids}")
//    @ApiOperation(value = "删除退款处理配置", notes = "删除退款处理配置")
//    RestResponse<Void> removeRefundDisposeConfig(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
