package com.dtyunxi.tcbj.center.trade.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

/**
* 厂家发货记录Eo对象
*
* @author by_liusong
* @since 2022-04-21
*/
@ApiModel(value = "DeliveryOrderLogisticsReqDto", description = "厂家发货记录Eo对象")
public class DeliveryOrderLogisticsReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  订单编号
    */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
    *  发货类型：factory.厂家发货
    */
    @ApiModelProperty(name = "deliveryType", value = "发货类型：factory.厂家发货")
    private Integer deliveryType;
    /**
    *  物流公司编号
    */
    @ApiModelProperty(name = "shippingCompanyCode", value = "物流公司编号")
    private String shippingCompanyCode;
    /**
    *  物流公司名称
    */
    @ApiModelProperty(name = "shippingCompanyName", value = "物流公司名称")
    private String shippingCompanyName;
    /**
    *  物流运单号
    */
    @ApiModelProperty(name = "shippingCode", value = "物流运单号")
    private String shippingCode;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setOrderNo(String orderNo){
    this.orderNo = orderNo;
    }
    public String getOrderNo(){
    return this.orderNo;
    }
    public void setDeliveryType(Integer deliveryType){
    this.deliveryType = deliveryType;
    }
    public Integer getDeliveryType(){
    return this.deliveryType;
    }
    public void setShippingCompanyCode(String shippingCompanyCode){
    this.shippingCompanyCode = shippingCompanyCode;
    }
    public String getShippingCompanyCode(){
    return this.shippingCompanyCode;
    }
    public void setShippingCompanyName(String shippingCompanyName){
    this.shippingCompanyName = shippingCompanyName;
    }
    public String getShippingCompanyName(){
    return this.shippingCompanyName;
    }
    public void setShippingCode(String shippingCode){
    this.shippingCode = shippingCode;
    }
    public String getShippingCode(){
    return this.shippingCode;
    }

    public DeliveryOrderLogisticsReqDto(String orderNo, Integer deliveryType, String shippingCompanyCode, String shippingCompanyName, String shippingCode) {
        this.orderNo = orderNo;
        this.deliveryType = deliveryType;
        this.shippingCompanyCode = shippingCompanyCode;
        this.shippingCompanyName = shippingCompanyName;
        this.shippingCode = shippingCode;
    }
}
