package com.yx.tcbj.center.trade.api.dto.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单V2025版本数据传输对象
 * 对应实体类层级：OrderV2025Eo -> OrderEo -> StdOrderEo
 * @author shizy
 * @date 2025/9/15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OrderV2025Dto {

    // ====================== 1. 从 OrderV2025Eo 继承的字段 ======================
    /**
     * 九州通发货标识
     */
    private String jztDistributeFlag;

    // ====================== 2. 从 OrderEo 继承的字段 ======================
    /**
     * 客户ID
     */
    private String customerId;

    /**
     * 发货日期
     */
    private Date deliveryDate;

    /**
     * 下单类型
     */
    private String placeType;

    /**
     * 作废人
     */
    private String obsoletePerson;

    /**
     * 作废时间
     */
    private Date obsoleteTime;

    /**
     * 作废原因
     */
    private String obsoleteReason;

    /**
     * 支付状态
     */
    private String payStatus;

    /**
     * 支付类型
     */
    private String payType;

    /**
     * 提交类型
     */
    private String submitType;

    /**
     * 总现金出点
     */
    private Integer totalCashOutPoint;

    /**
     * 总现金出金额
     */
    private BigDecimal totalCashOutAmount;

    /**
     * 总返利金额
     */
    private BigDecimal totalRebateAmount;

    /**
     * 赠送积分
     */
    private Integer presentPoint;

    /**
     * 礼品冻结金额
     */
    private BigDecimal giftFreezeAmount;

    /**
     * 抵扣金额
     */
    private BigDecimal deductionAmount;

    /**
     * 礼品抵扣金额
     */
    private BigDecimal giftDeductionAmount;

    /**
     * 礼品增加金额
     */
    private BigDecimal giftAddAmount;

    /**
     * 线下金额
     */
    private BigDecimal offlineAmount;

    /**
     * 配送类型
     */
    private Integer deliveryType;

    // ====================== 3. 从 StdOrderEo 继承的字段 ======================
    /**
     * 交易号（已废弃）
     * @deprecated
     */
    @Deprecated
    private String tradeNo;

    /**
     * 订单号（逻辑主键）
     */
    private String orderNo;

    /**
     * 第三方订单号
     */
    private String thirdOrderNo;

    /**
     * 原始订单号
     */
    private String origOrderNo;

    /**
     * 第三方父订单号
     */
    private String thirdParentOrderNo;

    /**
     * 父订单号
     */
    private String parentOrderNo;

    /**
     * 销售渠道订单号
     */
    private String saleChannelOrderNo;

    /**
     * 源订单类型
     */
    private Integer sourceOrderType;

    /**
     * 线上/线下类型（0-线下，1-线上）
     */
    private Integer onlineType;

    /**
     * 设备类型（如：PC、APP、H5）
     */
    private String deviceType;

    /**
     * 商家来源
     */
    private String sellerSrc;

    /**
     * 商家ID
     */
    private String sellerId;

    /**
     * 店铺类型
     */
    private String shopType;

    /**
     * 店铺ID
     */
    private String shopId;

    /**
     * 店铺经营形式
     */
    private Integer shopBusinessForm;

    /**
     * 组织ID
     */
    private Long organizationId;

    /**
     * 组织名称
     */
    private String organizationName;

    /**
     * 用户来源
     */
    private String userSrc;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 下单用户ID
     */
    private String placeUserId;

    /**
     * 推荐人ID
     */
    private String referrerId;

    /**
     * 支付用户ID
     */
    private String payUserId;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 订单交易状态（如：待支付、待发货、已完成）
     */
    private String orderTradeStatus;

    /**
     * 业务状态
     */
    private String bizStatus;

    /**
     * 冻结状态
     */
    private String frozenStatus;

    /**
     * 审核类型
     */
    private Integer auditType;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 订单总金额
     */
    private BigDecimal totalAmount;

    /**
     * 实付金额
     */
    private BigDecimal payAmount;

    /**
     * 运费金额
     */
    private BigDecimal freightAmount;

    /**
     * 平台优惠金额
     */
    private BigDecimal platformDiscountAmount;

    /**
     * 店铺优惠金额
     */
    private BigDecimal shopDiscountAmount;

    /**
     * 使用积分
     */
    private Integer integral;

    /**
     * 积分优惠券（积分抵扣金额对应的积分）
     */
    private Integer pointCoupon;

    /**
     * 金额明细（JSON格式）
     */
    private String amountDetail;

    /**
     * 销售渠道
     */
    private String saleChannel;

    /**
     * 营销渠道
     */
    private String mktChannel;

    /**
     * 商品总数量
     */
    private Integer totalItemNum;

    /**
     * 买家备注
     */
    private String buyerRemark;

    /**
     * 卖家备注
     */
    private String sellerRemark;

    /**
     * 下单时间
     */
    private Date placeTime;

    /**
     * 订单修改时间
     */
    private Date changeTime;

    /**
     * 取消类型
     */
    private String cancelType;

    /**
     * 取消时间
     */
    private Date cancelTime;

    /**
     * 取消原因描述
     */
    private String cancelDesc;

    /**
     * 订单结束时间
     */
    private Date endTime;

    /**
     * 收货地址（JSON格式）
     */
    private String deliveryAddress;

    /**
     * 运费承担方（0-买家，1-卖家）
     */
    private Integer freightPayer;

    /**
     * 买家昵称
     */
    private String buyerNickname;

    /**
     * 仓库编码
     */
    private String warehouseCode;

    /**
     * 卖家昵称
     */
    private String sellerNickname;

    /**
     * 全部金额（含优惠前总金额）
     */
    private BigDecimal allAmount;

    /**
     * 折扣差额
     */
    private BigDecimal discountMargin;

    /**
     * 订单关闭时间
     */
    private Date closeTime;

    /**
     * 总优惠金额
     */
    private BigDecimal discountAmount;

    /**
     * 店铺编码
     */
    private String shopCode;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 是否拆分订单（0-未拆分，1-已拆分）
     */
    private Integer isSplit;

    /**
     * 是否有收货地址（0-无，1-有）
     */
    private Integer hasDeliveryAddress;

    /**
     * 是否加急订单（0-否，1-是）
     */
    private Integer isUrgent;

    /**
     * 是否需要发票（0-不需要，1-需要）
     */
    private Integer invoiceFlag;

    /**
     * 实际发货时间
     */
    private Date deliveryTime;

    /**
     * 买家签收时间
     */
    private Date receiveTime;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 商品分账ID
     */
    private Long itemShareId;

    /**
     * 物流信息（JSON格式，含物流公司、物流单号等）
     */
    private String deliveryInfo;

    /**
     * 是否货到付款（0-否，1-是）
     */
    private Integer cashOnDelivery;

    /**
     * 业务线类型
     */
    private Integer busType;

    /**
     * 商品类型
     */
    private Integer itemType;

    /**
     * 是否有退货（0-无，1-有）
     */
    private Integer isReturn;

    /**
     * 是否周期购订单（0-否，1-是）
     */
    private Integer isCycleBuy;

    /**
     * 订单标签（多个标签用逗号分隔）
     */
    private String orderTags;

    /**
     * 流程定义ID（工作流相关）
     */
    private Long flowDefId;
}