package com.yx.tcbj.center.trade.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

/**
* 退款处理配置Eo对象
*
* @author 杰俊
* @since 2021-12-28
*/
@ApiModel(value = "RefundDisposeConfigRespDto", description = "退款处理配置Eo对象")
public class RefundDisposeConfigRespDto extends BaseRespDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  客户ID
    */
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;
    /**
    *  订单编号
    */
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
    *  退货原因 1：质量问题  2：非质量问题
    */
    @ApiModelProperty(name = "returnsCause", value = "退货原因 1：质量问题  2：非质量问题")
    private Integer returnsCause;
    /**
    *  退款计算方式 1：按折扣后实卖金额退  2：按折扣前金额退
    */
    @ApiModelProperty(name = "returnsWay", value = "退款计算方式 1：按折扣后实卖金额退  2：按折扣前金额退")
    private Integer returnsWay;
    /**
    *  实退金额
    */
    @ApiModelProperty(name = "realRefundAmount", value = "实退金额")
    private BigDecimal realRefundAmount;
    /**
    *  退货额度内-应退金额
    */
    @ApiModelProperty(name = "returnsInnerQuota", value = "退货额度内-应退金额")
    private BigDecimal returnsInnerQuota;
    /**
    *  退货额度内-实退比例
    */
    @ApiModelProperty(name = "returnsInnerScale", value = "退货额度内-实退比例")
    private BigDecimal returnsInnerScale;
    /**
    *  退货额度内-小计
    */
    @ApiModelProperty(name = "returnsInnerTotal", value = "退货额度内-小计")
    private BigDecimal returnsInnerTotal;
    /**
    *  退货额度外-应退金额
    */
    @ApiModelProperty(name = "returnsOuterQuota", value = "退货额度外-应退金额")
    private BigDecimal returnsOuterQuota;
    /**
    *  退货额度外-实退比例
    */
    @ApiModelProperty(name = "returnsOuterScale", value = "退货额度外-实退比例")
    private BigDecimal returnsOuterScale;
    /**
    *  退货额度外-小计
    */
    @ApiModelProperty(name = "returnsOuterTotal", value = "退货额度外-小计")
    private BigDecimal returnsOuterTotal;
    /**
    *  退货额度类型 1：扣减  -1：不扣减
    */
    @ApiModelProperty(name = "returnsQuotaType", value = "退货额度类型 1：扣减  -1：不扣减")
    private Integer returnsQuotaType;
    /**
    *  退货额度金额
    */
    @ApiModelProperty(name = "returnsQuotaAmount", value = "退货额度金额")
    private BigDecimal returnsQuotaAmount;
    /**
    *  赠品额度金额
    */
    @ApiModelProperty(name = "giftQuota", value = "赠品额度金额")
    private BigDecimal giftQuota;
    /**
    *  退货额度类型 1：扣减  -1：不扣减
    */
    @ApiModelProperty(name = "discountQuotaType", value = "退货额度类型 1：扣减  -1：不扣减")
    private Integer discountQuotaType;
    /**
    *  折扣额度金额
    */
    @ApiModelProperty(name = "discountQuota", value = "折扣额度金额")
    private BigDecimal discountQuota;
    /**
    *  
    */
    @ApiModelProperty(name = "returnsBackType", value = "")
    private Integer returnsBackType;
    /**
    *  
    */
    @ApiModelProperty(name = "returnsBackAmount", value = "")
    private BigDecimal returnsBackAmount;
    /**
    *  
    */
    @ApiModelProperty(name = "giftQuotaType", value = "")
    private Integer giftQuotaType;

    @ApiModelProperty(name = "refundChannelType",value = "退款渠道类型，lsw新增用于增加退款的种类进行判断")
    private Integer refundChannelType;
    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setCustomerId(Long customerId){
    this.customerId = customerId;
    }
    public Long getCustomerId(){
    return this.customerId;
    }
    public void setOrderNo(String orderNo){
    this.orderNo = orderNo;
    }
    public String getOrderNo(){
    return this.orderNo;
    }
    public void setReturnsCause(Integer returnsCause){
    this.returnsCause = returnsCause;
    }
    public Integer getReturnsCause(){
    return this.returnsCause;
    }
    public void setReturnsWay(Integer returnsWay){
    this.returnsWay = returnsWay;
    }
    public Integer getReturnsWay(){
    return this.returnsWay;
    }
    public void setRealRefundAmount(BigDecimal realRefundAmount){
    this.realRefundAmount = realRefundAmount;
    }
    public BigDecimal getRealRefundAmount(){
    return this.realRefundAmount;
    }
    public void setReturnsInnerQuota(BigDecimal returnsInnerQuota){
    this.returnsInnerQuota = returnsInnerQuota;
    }
    public BigDecimal getReturnsInnerQuota(){
    return this.returnsInnerQuota;
    }
    public void setReturnsInnerScale(BigDecimal returnsInnerScale){
    this.returnsInnerScale = returnsInnerScale;
    }
    public BigDecimal getReturnsInnerScale(){
    return this.returnsInnerScale;
    }
    public void setReturnsInnerTotal(BigDecimal returnsInnerTotal){
    this.returnsInnerTotal = returnsInnerTotal;
    }
    public BigDecimal getReturnsInnerTotal(){
    return this.returnsInnerTotal;
    }
    public void setReturnsOuterQuota(BigDecimal returnsOuterQuota){
    this.returnsOuterQuota = returnsOuterQuota;
    }
    public BigDecimal getReturnsOuterQuota(){
    return this.returnsOuterQuota;
    }
    public void setReturnsOuterScale(BigDecimal returnsOuterScale){
    this.returnsOuterScale = returnsOuterScale;
    }
    public BigDecimal getReturnsOuterScale(){
    return this.returnsOuterScale;
    }
    public void setReturnsOuterTotal(BigDecimal returnsOuterTotal){
    this.returnsOuterTotal = returnsOuterTotal;
    }
    public BigDecimal getReturnsOuterTotal(){
    return this.returnsOuterTotal;
    }
    public void setReturnsQuotaType(Integer returnsQuotaType){
    this.returnsQuotaType = returnsQuotaType;
    }
    public Integer getReturnsQuotaType(){
    return this.returnsQuotaType;
    }
    public void setReturnsQuotaAmount(BigDecimal returnsQuotaAmount){
    this.returnsQuotaAmount = returnsQuotaAmount;
    }
    public BigDecimal getReturnsQuotaAmount(){
    return this.returnsQuotaAmount;
    }
    public void setGiftQuota(BigDecimal giftQuota){
    this.giftQuota = giftQuota;
    }
    public BigDecimal getGiftQuota(){
    return this.giftQuota;
    }
    public void setDiscountQuotaType(Integer discountQuotaType){
    this.discountQuotaType = discountQuotaType;
    }
    public Integer getDiscountQuotaType(){
    return this.discountQuotaType;
    }
    public void setDiscountQuota(BigDecimal discountQuota){
    this.discountQuota = discountQuota;
    }
    public BigDecimal getDiscountQuota(){
    return this.discountQuota;
    }
    public void setReturnsBackType(Integer returnsBackType){
    this.returnsBackType = returnsBackType;
    }
    public Integer getReturnsBackType(){
    return this.returnsBackType;
    }
    public void setReturnsBackAmount(BigDecimal returnsBackAmount){
    this.returnsBackAmount = returnsBackAmount;
    }
    public BigDecimal getReturnsBackAmount(){
    return this.returnsBackAmount;
    }
    public void setGiftQuotaType(Integer giftQuotaType){
    this.giftQuotaType = giftQuotaType;
    }
    public Integer getGiftQuotaType(){
    return this.giftQuotaType;
    }

    public Integer getRefundChannelType() {
        return refundChannelType;
    }

    public void setRefundChannelType(Integer refundChannelType) {
        this.refundChannelType = refundChannelType;
    }
}
