package com.yx.tcbj.center.trade.api.dto.response;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 退货单V2025版本数据传输对象
 * 对应实体类层级：ReturnV2025Eo -> ReturnEo -> StdReturnEo
 * @author shizy
 * @date 2025/9/16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ReturnV2025Dto {

    // ====================== 1. 从 ReturnV2025Eo 继承的字段 ======================
    /**
     * 九州通发货标识
     */
    private String jztDistributeFlag;

    // ====================== 2. 从 ReturnEo 继承的字段 ======================
    /**
     * 退款状态
     */
    private String refundStatus;

    /**
     * 总金额
     */
    private BigDecimal totalAmount;

    /**
     * 下单用户ID
     */
    private String placeUserId;

    /**
     * 下单时间
     */
    private Date placeTime;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 退货描述
     */
    private String returnDesc;

    /**
     * 客户ID
     */
    private String customerId;

    /**
     * 流程定义ID
     */
    private Long flowDefId;

    /**
     * 完成时间
     */
    private Date finishTime;

    /**
     * 物流单号
     */
    private String deliveryNo;

    /**
     * 收货时间
     */
    private Date receiveTime;

    /**
     * 仓库编码
     */
    private String warehouseCode;

    /**
     * 拒收证明图片
     */
    private String refuseProofPics;

    /**
     * 退货运费金额
     */
    private BigDecimal returnFreightAmount;

    /**
     * 申请退货数量
     */
    private Long applyReturnQty;

    /**
     * 买家地址信息
     */
    private String buyerAddrInfo;

    /**
     * 创建方式
     */
    private String createMode;

    /**
     * 退货原因
     */
    private String returnReason;

    // ====================== 3. 从 StdReturnEo 继承的字段 ======================
    /**
     * 关联订单号
     */
    private String tradeNo;

    /**
     * 退货单号
     */
    private String returnNo;

    /**
     * 外部退货来源
     */
    private String extlReturnSrc;

    /**
     * 外部退货流水号
     */
    private String extlReturnSerial;

    /**
     * 退货状态
     */
    private String returnStatus;

    /**
     * 退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 退回积分
     */
    private Integer returnIntegral;

    /**
     * 退款金额明细（JSON格式）
     */
    private String refundAmountDetail;

    /**
     * 退货快递公司
     */
    private String returnExpressCompany;

    /**
     * 退货快递单号
     */
    private String returnExpressSerial;

    /**
     * 退货快递详情（JSON格式）
     */
    private String returnExpressDetail;

    /**
     * 取消类型
     */
    private String cancelType;

    /**
     * 取消时间
     */
    private Date cancelTime;

    /**
     * 取消原因描述
     */
    private String cancelDesc;

    /**
     * 退货类型
     */
    private String returnType;

    /**
     * 订单交易号
     */
    private String orderTradeNo;

    /**
     * 业务状态
     */
    private String bizStatus;

    /**
     * 业务类型
     */
    private String bizType;

    /**
     * 设备类型（如：PC、APP、H5）
     */
    private String deviceType;

    /**
     * 商家来源
     */
    private String sellerSrc;

    /**
     * 商家ID
     */
    private String sellerId;

    /**
     * 店铺类型
     */
    private String shopType;

    /**
     * 店铺ID
     */
    private String shopId;

    /**
     * 用户来源
     */
    private String userSrc;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 销售渠道
     */
    private String saleChannel;

    /**
     * 营销渠道
     */
    private String mktChannel;

    /**
     * 退回积分优惠券
     */
    private Integer returnPointCoupon;

    /**
     * 组织ID
     */
    private Long organizationId;

    /**
     * 组织名称
     */
    private String organizationName;

    /**
     * 是否已收到赠品
     */
    private Boolean receivedGift;

    /**
     * 退回返利金额
     */
    private BigDecimal returnRebate;

    // ====================== 4. 从 CubeBaseEo 继承的公共字段 ======================
    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 创建人ID
     */
    private String createUserId;

    /**
     * 更新人ID
     */
    private String updateUserId;

    /**
     * 逻辑删除标识（0-未删除，1-已删除）
     */
    private Integer isDeleted;
}
