//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.dtyunxi.yundt.cube.center.user.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.ModifyOrganizationReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.QueryOrgByCreditReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvInfoRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(
        tags = {"用户中心：组织机构管理服务(v3)"}
)
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-user-api-IOrganizationQueryExtApi",
        name = "${dtyunxi.yundt.cube_organization-center-user_api.name:organization-center-user}",
        url = "${dtyunxi.yundt.cube_organization-center-user_api:}",
        path = "/v3/organization"
)
public interface IOrganizationThreeApi {
    @PostMapping({"/queryOrgByCredit"})
    @ApiOperation(
            value = "通过统一社会信用代码查询机构信息",
            notes = "通过统一社会信用代码查询机构信息"
    )
    RestResponse<List<OrgAdvInfoRespDto>> queryOrgByCredit(@RequestBody QueryOrgByCreditReqDto queryOrgByCreditReqDto);

    @PostMapping({"/modify"})
    @ApiOperation(
            value = "修改org表",
            notes = "修改org表"
    )
    RestResponse<Integer> modify(@RequestBody ModifyOrganizationReqDto reqDto);

    @PostMapping({"/saveOrUpdateOrgInfo"})
    @ApiOperation(
            value = "修改orgInfo表",
            notes = "修改orgInfo表"
    )
    RestResponse<Long> saveOrUpdateOrgInfo(@RequestBody ModifyOrganizationInfoReqDto reqDto);
}
