/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.scheduleds.biz;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.EmployeeExtReqDto;
import com.dtyunxi.yundt.cube.center.user.api.enums.EmployeeStatusEnum;
import com.dtyunxi.yundt.cube.center.user.dao.das.EmployeeExpandDas;
import com.dtyunxi.yundt.cube.user.dao.eo.EmployeeExpandEo;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="employeeDisableScheduled")
@Scope(value="prototype")
public class EmployeeDisabelScheduled
extends SingleTupleScheduleEvent {
    private final Logger logger = LoggerFactory.getLogger(EmployeeDisabelScheduled.class);
    @Resource
    private EmployeeExpandDas employeeExpandDas;

    public void doUpdateStatus(String param) {
        Date nowDate = Calendar.getInstance().getTime();
        this.logger.info("\u5f00\u59cb\u6267\u884c\u4eba\u5458\u72b6\u6001\u66f4\u65b0\u903b\u8f91\uff08\u624b\u52a8\u8bbe\u7f6e\u4eba\u5458\u72b6\u6001\u4e3a\u7981\u7528\uff09\uff0c\u5165\u53c2:{}", (Object)param);
        if (StringUtils.isBlank((CharSequence)param)) {
            this.logger.info("\u5165\u53c2\u5185\u5bb9\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        EmployeeExtReqDto reqDto = (EmployeeExtReqDto)JSON.parseObject((String)param, EmployeeExtReqDto.class);
        if (Objects.isNull(reqDto.getStatus())) {
            this.logger.info("\u4eba\u5458\u72b6\u6001\u4e3a\u7a7a\uff0c\u4e0d\u505a\u5904\u7406\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        if (CollectionUtils.isEmpty((Collection)reqDto.getIds())) {
            this.logger.error("\u4eba\u5458IDs\u4e3a\u7a7a\uff0c\u4e2d\u65ad\u903b\u8f91\u5e76\u9000\u51fa\u65b9\u6cd5...");
            return;
        }
        EmployeeExpandEo eo = new EmployeeExpandEo();
        eo.setSqlFilters(Collections.singletonList(SqlFilter.in((String)"id", (Object)reqDto.getIds())));
        eo.setStatus(EmployeeStatusEnum.DISABLED.getKey());
        this.employeeExpandDas.updateSelectiveSqlFilter((BaseEo)eo);
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            this.doUpdateStatus(taskMsg.getContent());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8c03\u5ea6\u5f02\u5e38", (Throwable)e);
            return false;
        }
        return true;
    }

    public void before(TaskMsg taskMsg) {
    }

    public void after(TaskMsg taskMsg) {
    }
}

