/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.user.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrganizationInfoExtDto;
import com.dtyunxi.yundt.cube.center.user.biz.exception.BizException;
import com.dtyunxi.yundt.cube.center.user.biz.service.IOrgInfoExtService;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationDas;
import com.dtyunxi.yundt.cube.center.user.dao.das.OrganizationInfoDas;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.OrganizationInfoEo;
import com.dtyunxi.yundt.cube.center.user.dao.eo.StdOrganizationEo;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationInfoMapper;
import com.dtyunxi.yundt.cube.center.user.dao.mapper.OrganizationMapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrgInfoExtServiceImpl
implements IOrgInfoExtService {
    private static final Logger logger = LoggerFactory.getLogger(OrgInfoExtServiceImpl.class);
    @Resource
    private OrganizationMapper organizationMapper;
    @Resource
    private OrganizationInfoMapper organizationInfoMapper;
    @Resource
    private HttpServletRequest request;
    @Resource
    private OrganizationInfoDas organizationInfoDas;
    @Resource
    private OrganizationDas organizationDas;

    @Override
    public List<OrganizationInfoExtDto> queryOrgInfoByOrgId(List<Long> orgIdList) {
        QueryWrapper orgEo = new QueryWrapper();
        orgEo.in((Object)"id", orgIdList);
        orgEo.eq((Object)"dr", (Object)0);
        List organizationEos = this.organizationMapper.selectList((Wrapper)orgEo);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return Lists.newArrayList();
        }
        Map orgMap = organizationEos.stream().collect(Collectors.toMap(StdOrganizationEo::getCode, Function.identity()));
        List orgCodeList = organizationEos.stream().map(StdOrganizationEo::getCode).distinct().collect(Collectors.toList());
        QueryWrapper orgInfoEo = new QueryWrapper();
        orgInfoEo.in((Object)"org_code", orgCodeList);
        orgInfoEo.eq((Object)"dr", (Object)0);
        List orgInfoList = this.organizationInfoMapper.selectList((Wrapper)orgInfoEo);
        if (CollectionUtils.isEmpty((Collection)orgInfoList)) {
            return Lists.newArrayList();
        }
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)orgInfoList, OrganizationInfoExtDto.class);
        for (OrganizationInfoExtDto infoExtDto : dtoList) {
            if (orgMap.isEmpty() || !orgMap.containsKey(infoExtDto.getOrgCode())) continue;
            infoExtDto.setOrgId(((OrganizationEo)orgMap.get(infoExtDto.getOrgCode())).getId());
        }
        return dtoList;
    }

    @Override
    public Long addOrUpd(OrganizationInfoExtDto reqDto) {
        String currentOrgId = this.headerOrgId();
        if (StringUtils.isBlank((CharSequence)currentOrgId)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4ID");
        }
        OrganizationEo organizationEo = (OrganizationEo)this.organizationDas.selectByLogicKey((Object)Long.valueOf(currentOrgId));
        if (ObjectUtils.isEmpty((Object)organizationEo) || ObjectUtils.isEmpty((Object)organizationEo.getCode())) {
            throw new BizException("-1", "\u79df\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1a" + currentOrgId);
        }
        OrganizationInfoEo organizationInfoPrams = new OrganizationInfoEo();
        organizationInfoPrams.setOrgCode(organizationEo.getCode());
        List list = this.organizationInfoDas.select((BaseEo)organizationInfoPrams);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            OrganizationInfoEo organizationInfoEo = (OrganizationInfoEo)list.get(0);
            reqDto.setId(organizationInfoEo.getId());
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)organizationInfoEo);
            this.organizationInfoDas.updateSelective((BaseEo)organizationInfoEo);
        } else {
            OrganizationInfoEo organizationInfoEo = new OrganizationInfoEo();
            reqDto.setOrgCode(organizationEo.getCode());
            DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)organizationInfoEo);
            this.organizationInfoDas.insert((BaseEo)organizationInfoEo);
        }
        return organizationEo.getId();
    }

    private String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public List<OrganizationDto> getOrgByNameList(List<String> nameList) {
        if (CollectionUtils.isEmpty(nameList)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"name", nameList);
        wrapper.eq((Object)"dr", (Object)0);
        List organizationEos = this.organizationMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)organizationEos)) {
            return Lists.newArrayList();
        }
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)organizationEos, (Collection)dtoList, OrganizationDto.class);
        return dtoList;
    }
}

