/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector.zipkin.api;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.collector.DefaultTrackDataCollector;
import com.dtyunxi.cube.component.track.client.collector.config.TransactionTrackCollectorConfigVo;
import com.dtyunxi.cube.component.track.client.collector.zipkin.module.Span;
import com.dtyunxi.cube.component.track.client.collector.zipkin.vo.ZipKinSpanVoCollect;
import com.dtyunxi.cube.component.track.commons.constant.CollectExecutorMethodType;
import com.dtyunxi.cube.component.track.commons.utils.HttpUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZipkinApi {
    private static final Logger logger = LoggerFactory.getLogger(ZipkinApi.class);
    private static final Map<String, String> DEFAULT_HEADERS = new HashMap<String, String>();
    @Resource
    private TransactionTrackCollectorConfigVo transactionTrackCollectorConfigVo;
    @Resource
    private DefaultTrackDataCollector defaultTrackDataCollector;

    public void spansPost(List<Span> spans) {
        String url = this.transactionTrackCollectorConfigVo.getZipkinHost() + "/api/v2/spans";
        try {
            String body = JSON.toJSONString(spans);
            logger.debug("\u6267\u884cspansPost,url={},body={}", (Object)url, (Object)body);
            String spanResult = HttpUtil.post((String)url, (String)body, DEFAULT_HEADERS);
            logger.debug("\u6267\u884cspansPost\u7ed3\u679c={}", (Object)spanResult);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void asyncSpansPost(List<Span> spans) {
        try {
            ZipKinSpanVoCollect zipKinSpanVo = new ZipKinSpanVoCollect();
            zipKinSpanVo.setCollectExecutorMethodType(CollectExecutorMethodType.ZIPKIN_POST_API);
            zipKinSpanVo.setSpans(spans);
            this.defaultTrackDataCollector.collectAndDistribute(zipKinSpanVo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        DEFAULT_HEADERS.put("Content-Type", "application/json");
    }
}

