/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.collector.zipkin.module;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The network context of a node in the service graph")
@JsonPropertyOrder(value={"serviceName", "ipv4", "ipv6", "port"})
public class Endpoint {
    public static final String JSON_PROPERTY_SERVICE_NAME = "serviceName";
    private String serviceName;
    public static final String JSON_PROPERTY_IPV4 = "ipv4";
    private String ipv4;
    public static final String JSON_PROPERTY_IPV6 = "ipv6";
    private String ipv6;
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;

    public Endpoint serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Lower-case label of this node in the service graph, such as \"favstar\". Leave absent if unknown.  This is a primary label for trace lookup and aggregation, so it should be intuitive and consistent. Many use a name from service discovery. ")
    @JsonProperty(value="serviceName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Endpoint ipv4(String ipv4) {
        this.ipv4 = ipv4;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text representation of the primary IPv4 address associated with this connection. Ex. 192.168.99.100 Absent if unknown. ")
    @JsonProperty(value="ipv4")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpv4() {
        return this.ipv4;
    }

    public void setIpv4(String ipv4) {
        this.ipv4 = ipv4;
    }

    public Endpoint ipv6(String ipv6) {
        this.ipv6 = ipv6;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text representation of the primary IPv6 address associated with a connection. Ex. 2001:db8::c001 Absent if unknown.  Prefer using the ipv4 field for mapped addresses. ")
    @JsonProperty(value="ipv6")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIpv6() {
        return this.ipv6;
    }

    public void setIpv6(String ipv6) {
        this.ipv6 = ipv6;
    }

    public Endpoint port(Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Depending on context, this could be a listen port or the client-side of a socket. Absent if unknown. Please don't set to zero. ")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.serviceName, endpoint.serviceName) && Objects.equals(this.ipv4, endpoint.ipv4) && Objects.equals(this.ipv6, endpoint.ipv6) && Objects.equals(this.port, endpoint.port);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.ipv4, this.ipv6, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Endpoint {\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    ipv4: ").append(this.toIndentedString(this.ipv4)).append("\n");
        sb.append("    ipv6: ").append(this.toIndentedString(this.ipv6)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

