/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.config;

import com.dtyunxi.cube.component.track.client.aspect.TransactionActionAspect;
import com.dtyunxi.cube.component.track.client.aspect.TransactionNodeActionAspect;
import com.dtyunxi.cube.component.track.client.collector.executor.AsyncTrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.CommitTrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.EmptyTrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.TrackDataDistributeExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.receive.DefaultTrackDataReceiveExecutor;
import com.dtyunxi.cube.component.track.client.collector.executor.receive.TrackDataReceiveExecutor;
import com.dtyunxi.cube.component.track.client.collector.scheduled.TrackDataCollectorScheduled;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackClientConfigVo;
import com.dtyunxi.cube.component.track.client.executor.DefaultTransactionTrackExecutor;
import com.dtyunxi.cube.component.track.client.executor.DefaultTransactionTrackNodeExecutor;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackExecutor;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackNodeExecutor;
import com.dtyunxi.cube.component.track.client.feign.filter.TransactionTrackFeignFilter;
import com.dtyunxi.cube.component.track.config.TransactionTrackInterceptorWebMvcConfigurer;
import com.dtyunxi.cube.component.track.retry.executor.DefaultTrackRetryExecutor;
import com.dtyunxi.cube.component.track.retry.executor.TrackRetryExecutor;
import com.dtyunxi.cube.component.track.retry.scheduled.TrackRetrySignalScheduled;
import feign.RequestInterceptor;
import java.util.ArrayList;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties
public class TransactionTrackAutoConfiguration {
    @Bean
    public TransactionTrackInterceptorWebMvcConfigurer transactionTrackInterceptorWebMvcConfigurer(TransactionTrackClientConfigVo transactionTrackClientConfigVo) {
        ArrayList<String> urls = new ArrayList<String>();
        urls.add("/swagger-resources/**");
        urls.add("/swagger-resources");
        urls.add("/webjars/springfox-swagger-ui/**");
        urls.add("/webjars/springfox-swagger-ui/*.*");
        urls.add("/swagger-ui.html");
        urls.add("/swagger-ui/*.*");
        urls.add("/v2/api-docs");
        urls.add("/favicon.ico");
        urls.add("/xapi.html");
        urls.add("/xapi/**");
        return new TransactionTrackInterceptorWebMvcConfigurer(transactionTrackClientConfigVo).setExcludePathPatterns(urls);
    }

    @Bean
    @ConditionalOnClass(value={RequestInterceptor.class})
    public TransactionTrackFeignFilter transactionTrackFeignFilter(TransactionTrackClientConfigVo transactionTrackClientConfigVo) {
        return new TransactionTrackFeignFilter(transactionTrackClientConfigVo);
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionTrackExecutor.class})
    public TransactionTrackExecutor transactionTrackExecutor() {
        return new DefaultTransactionTrackExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TransactionTrackNodeExecutor.class})
    public TransactionTrackNodeExecutor transactionTrackNodeExecutor() {
        return new DefaultTransactionTrackNodeExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackRetryExecutor.class})
    @ConditionalOnProperty(prefix="transaction.track.client.retry", value={"enable"}, havingValue="true")
    public TrackRetryExecutor trackRetryExecutor(BeanFactory beanFactory) {
        return new DefaultTrackRetryExecutor(beanFactory);
    }

    @Bean
    @ConditionalOnProperty(prefix="transaction.track.client.retry", value={"enable"}, havingValue="true")
    public TrackRetrySignalScheduled trackRetrySignalScheduled() {
        return new TrackRetrySignalScheduled();
    }

    @Bean
    @ConditionalOnProperty(prefix="transaction.track.collector.default", value={"enable"}, havingValue="true")
    public TrackDataDistributeExecutor defaultTrackDataCollectorExecutor() {
        return new AsyncTrackDataDistributeExecutor();
    }

    @Bean
    @ConditionalOnProperty(prefix="transaction.track.collector.default", value={"enable"}, havingValue="true")
    public TrackDataCollectorScheduled trackDataCollectorScheduled() {
        return new TrackDataCollectorScheduled();
    }

    @Bean
    @ConditionalOnProperty(prefix="transaction.track.collector.commit", value={"enable"}, havingValue="true")
    public TrackDataDistributeExecutor commitTrackDataCollectorExecutor() {
        return new CommitTrackDataDistributeExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackDataDistributeExecutor.class})
    public TrackDataDistributeExecutor commitTrackDataCollectorExecutorEmpty() {
        return new EmptyTrackDataDistributeExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={TrackDataReceiveExecutor.class})
    public TrackDataReceiveExecutor defaultTrackDataReceiveExecutor() {
        return new DefaultTrackDataReceiveExecutor();
    }

    @Configuration
    protected static class TransactionTrackAspectConfiguration {
        protected TransactionTrackAspectConfiguration() {
        }

        @Bean
        public TransactionActionAspect transactionActionAspect() {
            return new TransactionActionAspect();
        }

        @Bean
        public TransactionNodeActionAspect transactionNodeActionAspect() {
            return new TransactionNodeActionAspect();
        }
    }
}

