/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.aspect;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackExecutor;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackNodeExecutor;
import com.dtyunxi.cube.component.track.commons.utils.RequestId;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionTrackContextVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionTrackResult;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class TransactionActionAspect {
    private static final Logger logger = LoggerFactory.getLogger(TransactionActionAspect.class);
    @Resource
    private TransactionTrackExecutor transactionTrackExecutor;
    @Resource
    private TransactionTrackNodeExecutor transactionTrackNodeExecutor;

    public TransactionActionAspect() {
        logger.info("TransactionActionAspect\u5df2\u88c5\u8f7d");
    }

    @Pointcut(value="@within(com.dtyunxi.cube.component.track.commons.aspect.annotation.TransactionAction) ||@annotation(com.dtyunxi.cube.component.track.commons.aspect.annotation.TransactionAction) || @within(com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode) ||@annotation(com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode) ||@within(com.dtyunxi.cube.component.track.commons.aspect.annotation.OpenApiExecuteLog)||@annotation(com.dtyunxi.cube.component.track.commons.aspect.annotation.OpenApiExecuteLog) ")
    public void transactionActionAop() {
    }

    @Around(value="transactionActionAop()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        logger.debug("\u3010TransactionActionAspect.around\u3011class.method={}.{}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        point.getArgs();
        TransactionTrackContextVo contextVo = this.loadContext();
        TransactionTrackResult transactionTrackResult = this.transactionTrackExecutor.transactionAction(point);
        logger.debug(">>>>>>>>>>>>>>after.transactionAction:{}", (Object)JSON.toJSONString((Object)ServerContextUtils.getKeys()));
        Object obj = null;
        Throwable exception = null;
        try {
            obj = point.proceed();
        }
        catch (Throwable throwable) {
            exception = throwable;
            throw throwable;
        }
        finally {
            this.transactionTrackExecutor.transactionEnd(transactionTrackResult, obj, exception);
            this.revertContext(transactionTrackResult, contextVo);
            logger.debug(">>>>>>>>>>>>>>after.revertContext:{}", (Object)JSON.toJSONString((Object)ServerContextUtils.getKeys()));
        }
        return obj;
    }

    public TransactionTrackContextVo loadContext() {
        TransactionTrackContextVo contextVo = new TransactionTrackContextVo();
        String reqId = ServerContextUtils.getReqId();
        if (reqId == null) {
            reqId = RequestId.createReqId();
            ServerContextUtils.setReqId((String)reqId);
            contextVo.setClearReqId(true);
        }
        if (ServerContextUtils.checkNoTransactionVoByContext((String)"transaction.overall", (String)"transaction.overall.json")) {
            contextVo.setClearTransactionVo(true);
        }
        return contextVo;
    }

    public void revertContext(TransactionTrackResult transactionTrackResult, TransactionTrackContextVo contextVo) {
        ServerContextUtils.set((String)"transaction.process", (Object)transactionTrackResult.getParentTransactionVo());
        if (contextVo.isClearTransactionVo()) {
            ServerContextUtils.remove((String)"transaction.overall");
            ServerContextUtils.remove((String)"transaction.overall.json");
            ServerContextUtils.remove((String)"transaction.process");
            ServerContextUtils.remove((String)"transaction.process.json");
        }
        if (contextVo.isClearReqId()) {
            ServerContextUtils.removeReqId();
        }
    }
}

