/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.component.track.client.executor;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.client.build.TransactionVoBuilder;
import com.dtyunxi.cube.component.track.client.config.TransactionTrackClientConfigVo;
import com.dtyunxi.cube.component.track.client.executor.TransactionAsync;
import com.dtyunxi.cube.component.track.client.executor.TransactionTrackExecutor;
import com.dtyunxi.cube.component.track.commons.constant.CollectExecutorMethodType;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.cube.component.track.commons.utils.ServerContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.TransactionBaseVo;
import com.dtyunxi.cube.component.track.commons.vo.TransactionTrackResult;
import com.dtyunxi.cube.component.track.commons.vo.TransactionVo;
import com.dtyunxi.cube.module.track.service.ITransactionRegisterService;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionTrackExecutor
implements TransactionTrackExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTransactionTrackExecutor.class);
    @Resource
    private ITransactionRegisterService transactionRegisterService;
    @Resource
    private TransactionAsync transactionAsync;
    @Resource
    private TransactionTrackClientConfigVo transactionTrackClientConfigVo;

    @Override
    public TransactionTrackResult transactionAction(ProceedingJoinPoint point) {
        logger.debug("\u3010TransactionTrackExecutor.transactionAction\u3011class.method={}.{}", (Object)point.getSignature().getDeclaringTypeName(), (Object)point.getSignature().getName());
        TransactionVoBuilder builder = new TransactionVoBuilder();
        TransactionVo transactionVo = builder.build(point);
        logger.debug("\u3010TransactionTrackExecutor.builder.vo\u3011vo={}", (Object)JSON.toJSONString((Object)transactionVo));
        transactionVo = this.transactionTrackClientConfigVo.isAsyncCollect() ? (TransactionVo)this.transactionAsync.registerTransactionExecuteVo(CollectExecutorMethodType.TT_SAVE_API, (TransactionBaseVo)transactionVo) : this.transactionRegisterService.registerTransaction(transactionVo);
        return this.buildTransactionTrackResultAndResetContext(transactionVo);
    }

    @Override
    public void transactionEnd(TransactionTrackResult result, Object obj, Throwable throwable) {
        try {
            logger.debug("\u3010TransactionTrackExecutor.transactionEnd\u3011result={}\uff0cobj={}, isThrowable={}", new Object[]{JSON.toJSONString((Object)result), JSON.toJSONString((Object)obj), throwable != null});
            if (throwable != null) {
                logger.debug("\u3010TransactionTrackExecutor.transactionEnd\u3011throwable:" + throwable.getMessage(), throwable);
            }
            TransactionVo updateTransactionVo = this.buildUpdateTransactionVo(result.getTransactionVo(), obj, throwable);
            if (this.transactionTrackClientConfigVo.isAsyncCollect()) {
                this.transactionAsync.registerTransactionExecuteVo(CollectExecutorMethodType.TT_MODIFY_API, (TransactionBaseVo)updateTransactionVo);
            } else {
                this.transactionRegisterService.modifyTransaction(updateTransactionVo);
            }
        }
        catch (Throwable t1) {
            logger.error(t1.getMessage(), t1);
        }
    }

    public void rebuildTransactionContext(TransactionVo transactionVo) {
        TransactionVo overallTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.overall", (String)"transaction.overall.json");
        if (overallTransaction == null) {
            transactionVo.setOverTransactionId(transactionVo.getId());
            ServerContextUtils.set((String)"transaction.overall", (Object)transactionVo);
        }
        ServerContextUtils.set((String)"transaction.process", (Object)transactionVo);
    }

    public TransactionTrackResult buildTransactionTrackResultAndResetContext(TransactionVo transactionVo) {
        TransactionTrackResult transactionTrackResult = new TransactionTrackResult();
        transactionTrackResult.setTransactionVo(transactionVo);
        TransactionVo processTransaction = ServerContextUtils.loadTransactionVoByContext((String)"transaction.process", (String)"transaction.process.json");
        transactionTrackResult.setParentTransactionVo(processTransaction);
        this.rebuildTransactionContext(transactionVo);
        return transactionTrackResult;
    }

    public TransactionVo buildUpdateTransactionVo(TransactionVo resultTransactionVo, Object obj, Throwable throwable) {
        TransactionVo updateTransactionVo = new TransactionVo();
        updateTransactionVo.setId(resultTransactionVo.getId());
        if (obj != null && throwable == null) {
            updateTransactionVo.setTransactionStatus(Integer.valueOf(TransactionStatusEnum.T_SUCCESS.getCode()));
        } else if (throwable != null) {
            updateTransactionVo.setTransactionStatus(Integer.valueOf(TransactionStatusEnum.T_ERROR.getCode()));
        }
        return updateTransactionVo;
    }
}

