/*
 * @(#)ItemVersion.java 1.0 2018-08-22
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品变更申请
 *
 * @author 零星 modify by 简树
 * @since 2.0.0
 */
@Table(name = "it_item_change_apply")
public class StdItemChangeApplyEo extends CubeBaseEo {
    /**
     * 编号
     */
    @Column(name = "code")
    private String code;
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 商品类型1普通商品2产品3组合商品 默认1
     */
    @Column(name = "type")
    private Integer type;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 所属人ID
     */
    @Column(name = "owner_id")
    private Long ownerId;

    /**
     * 版本状态
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 商品信息
     */
    @Column(name = "content")
    private String content;
    /**
     * 品牌名称
     */
    @Column(name = "brand")
    private String brand;
    /**
     * 品牌ID
     */
    @Column(name = "brand_id")
    private Long brandId;
    /**
     * 目录Id
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 目录名称
     */
    @Column(name = "dir_name")
    private String dirName;

    /**
     * 供应商Id
     */
    @Column(name = "supplier_id")
    private Long supplierId;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @Column(name = "bus_type")
    private Integer busType;

    public static StdItemChangeApplyEo newInstance() {
        return (StdItemChangeApplyEo) BaseEo.newInstance(StdItemChangeApplyEo.class);
    }

    public static StdItemChangeApplyEo newInstance(Map<String, Object> extFields) {
        return (StdItemChangeApplyEo) BaseEo.newInstance(StdItemChangeApplyEo.class, extFields);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getBusType() {
        return busType;
    }
    public void setBusType(Integer busType) {
        this.busType = busType;
    }
}
