package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 属性名
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_prop_name")
public class StdPropNameEo extends CubeBaseEo {
    /**
     * 编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 1 选择  2 输入
     */
    @Column(name = "input_type")
    private Integer inputType;

    /**
     * 是否必选: 1 是 0 否
     */
    @Column(name = "required")
    private Integer required;

    /**
     * 字符数限制
     */
    @Column(name = "char_size_limit")
    private Integer charSizeLimit;

    /**
     * 输入提示语
     */
    @Column(name = "prompt")
    private String prompt;

    /**
     * 排序
     */
    @Column(name = "sort")
    private Integer sort;

    /**
     * 描述
     */
    @Column(name = "description")
    private String description;

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;

    public Integer getRequired() {
        return required;
    }

    public void setRequired(Integer required) {
        this.required = required;
    }

    public Integer getCharSizeLimit() {
        return charSizeLimit;
    }

    public void setCharSizeLimit(Integer charSizeLimit) {
        this.charSizeLimit = charSizeLimit;
    }

    public String getPrompt() {
        return prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public static StdPropNameEo newInstance() {
        return (StdPropNameEo) BaseEo.newInstance(StdPropNameEo.class);
    }

    public static StdPropNameEo newInstance(Map<String, Object> extFields) {
        return (StdPropNameEo) BaseEo.newInstance(StdPropNameEo.class, extFields);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public Integer getInputType() {
        return this.inputType;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
}