package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品统计信息
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_stat")
public class StdStatEo extends CubeBaseEo {
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    @LogicColumn
    private Long itemId;
    /**
     * SKUID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 购买数量
     */
    @Column(name = "sales_count")
    private Long salesCount;
    /**
     * 评论数量
     */
    @Column(name = "comment_count")
    private Long commentCount;
    /**
     * 收藏数
     */
    @Column(name = "collect_count")
    private Long collectCount;

    public static StdStatEo newInstance() {
        return (StdStatEo) BaseEo.newInstance(StdStatEo.class);
    }

    public static StdStatEo newInstance(Map<String, Object> extFields) {
        return (StdStatEo) BaseEo.newInstance(StdStatEo.class, extFields);
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setSalesCount(Long salesCount) {
        this.salesCount = salesCount;
    }

    public Long getSalesCount() {
        return this.salesCount;
    }

    public void setCommentCount(Long commentCount) {
        this.commentCount = commentCount;
    }

    public Long getCommentCount() {
        return this.commentCount;
    }

    public void setCollectCount(Long collectCount) {
        this.collectCount = collectCount;
    }

    public Long getCollectCount() {
        return this.collectCount;
    }
}