/**
 * @(#) StdShelfSnapshotEo.java 1.0 2019-08-01
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 上架快照信息
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_shelf_snapshot")
public class StdShelfSnapshotEo extends CubeBaseEo {
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 目录ID
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 上架快照信息
     */
    @Column(name = "shelf_snapshot")
    private String shelfSnapshot;

    public static StdShelfSnapshotEo newInstance() {
        return (StdShelfSnapshotEo) BaseEo.newInstance(StdShelfSnapshotEo.class);
    }

    public static StdShelfSnapshotEo newInstance(Map<String, Object> extFields) {
        return (StdShelfSnapshotEo) BaseEo.newInstance(StdShelfSnapshotEo.class, extFields);
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getShelfSnapshot() {
        return shelfSnapshot;
    }

    public void setShelfSnapshot(String shelfSnapshot) {
        this.shelfSnapshot = shelfSnapshot;
    }
}
