
/*
 * @(#)DirectoryItemEo.java 1.0 2018-08-21
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.commons.dto.TreeNode;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

@Table(name = "it_dir")
public class StdDirEo extends CubeBaseEo implements TreeNode {
    /**
     * 编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 根节点
     */
    @Column(name = "root_id")
    private Long rootId;
    /**
     * 父节点
     */
    @Column(name = "parent_id")
    private Long parentId;
    /**
     * 目录名
     */
    @Column(name = "name")
    private String name;
    /**
     * 引用目录
     */
    @Column(name = "link")
    private Long link;
    /**
     * 其他属性
     */
    @Column(name = "attrs")
    private String attrs;
    /**
     * 左值
     */
    @Column(name = "lv")
    private Integer lv;
    /**
     * 右值
     */
    @Column(name = "rv")
    private Integer rv;
    /**
     * 排序
     */
    @Column(name = "sort")
    private Integer sort;
    /**
     * 状态 0 禁用1启用
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 描述
     */
    @Column(name = "description")
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    private String frontRelationBack;

    private Long shopId;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    /**
     * 店铺类目关联后台类目
     */
//    private String shopRelationBack1;
    public String getFrontRelationBack() {
        return frontRelationBack;
    }

    public void setFrontRelationBack(String frontRelationBack) {
        this.frontRelationBack = frontRelationBack;
    }

//    public String getShopRelationBack1() {
//        return shopRelationBack1;
//    }
//
//    public void setShopRelationBack1(String shopRelationBack1) {
//        this.shopRelationBack1 = shopRelationBack1;
//    }

    public static StdDirEo newInstance() {
        return (StdDirEo) BaseEo.newInstance(StdDirEo.class);
    }

    public static StdDirEo newInstance(Map<String, Object> extFields) {
        return (StdDirEo) BaseEo.newInstance(StdDirEo.class, extFields);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Long getRootId() {
        return rootId;
    }

    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getLink() {
        return link;
    }

    public void setLink(Long link) {
        this.link = link;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public Integer getLv() {
        return lv;
    }

    public void setLv(Integer lv) {
        this.lv = lv;
    }

    public Integer getRv() {
        return rv;
    }

    public void setRv(Integer rv) {
        this.rv = rv;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || getClass() != object.getClass()) {
            return false;
        }

        StdDirEo that = (StdDirEo) object;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}

