/**
 * @(#) IExampleService.java 1.1.0 2018-08-22
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品属性实体类
 *
 * @author 佐助
 * @since 2.0.0
 */
@Table(name = "it_item_attributes")
public class StdItemAttributesEo extends CubeBaseEo {
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品属性
     */
    @Column(name = "attrs")
    private String attrs;
    /**
     * 附加属性
     */
    @Column(name = "search_attrs")
    private String searchAttrs;

    public static StdItemAttributesEo newInstance() {
        return (StdItemAttributesEo) BaseEo.newInstance(StdItemAttributesEo.class);
    }

    public static StdItemAttributesEo newInstance(Map<String, Object> extFields) {
        return (StdItemAttributesEo) BaseEo.newInstance(StdItemAttributesEo.class, extFields);
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public String getSearchAttrs() {
        return searchAttrs;
    }

    public void setSearchAttrs(String searchAttrs) {
        this.searchAttrs = searchAttrs;
    }
}
