/*
 * @(#)InventoryException.java 1.0 2018-08-23
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 目录检索属性Eo
 *
 * @author 简树
 * @since 1.0.0
 */
@Table(name = "it_r_dir_item_attributes")
public class StdDirItemAttributesRelationEo extends CubeBaseEo {
    /**
     * 目录id
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 属性名
     */
    @Column(name = "prop_name")
    private String propName;
    /**
     * 属性值
     */
    @Column(name = "prop_value")
    private String propValue;

    public static StdDirItemAttributesRelationEo newInstance() {
        return (StdDirItemAttributesRelationEo) BaseEo.newInstance(StdDirItemAttributesRelationEo.class);
    }

    public static StdDirItemAttributesRelationEo newInstance(Map<String, Object> extFields) {
        return (StdDirItemAttributesRelationEo) BaseEo.newInstance(StdDirItemAttributesRelationEo.class, extFields);
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getPropName() {
        return propName;
    }

    public void setPropName(String propName) {
        this.propName = propName;
    }

    public String getPropValue() {
        return propValue;
    }

    public void setPropValue(String propValue) {
        this.propValue = propValue;
    }
}
