/**
 * @(#) StdDirRelationEo.java 1.0 2019-01-03
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 目录引用关联关系Eo
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_r_dir")
public class StdDirRelationEo extends CubeBaseEo {

    /**
     * 目录ID
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 引用目录ID
     */
    @Column(name = "link_dir_id")
    private Long linkDirId;

    public static StdDirRelationEo newInstance() {
        return (StdDirRelationEo) BaseEo.newInstance(StdDirRelationEo.class);
    }

    public static StdDirRelationEo newInstance(Map<String, Object> extFields) {
        return (StdDirRelationEo) BaseEo.newInstance(StdDirRelationEo.class, extFields);
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public Long getLinkDirId() {
        return linkDirId;
    }

    public void setLinkDirId(Long linkDirId) {
        this.linkDirId = linkDirId;
    }
}
