/*
 * @(#)ItemPriceEo.java 1.0 2018-08-20
 *
 * Copyright (c) 2017, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Map;

/**
 * 商品价格
 *
 * @author 简树 零星
 * @since 2.0.0
 */
@Table(name = "it_item_price")
public class StdItemPriceEo extends CubeBaseEo {
    /**
     * 价格名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 币种
     */
    @Column(name = "currency")
    private String currency;
    /**
     * 价格
     */
    @Column(name = "price")
    private BigDecimal price;
    /**
     * 消耗积分
     */
    @Column(name = "points")
    private Long points;
    /**
     * 价格体系
     */
    @Column(name = "price_type")
    private String priceType;
    /**
     * 是否激活 0不激活 1 激活
     */
    @Column(name = "is_actived")
    private Integer isActived;

    /**
     * 价格类型id
     */
    @Column(name = "price_type_id")
    private Long priceTypeId;

    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;

    /**
     * 商品 skuId
     */
    @Column(name = "sku_id")
    private Long skuId;

    public static StdItemPriceEo newInstance() {
        return (StdItemPriceEo) BaseEo.newInstance(StdItemPriceEo.class);
    }

    public static StdItemPriceEo newInstance(Map<String, Object> extFields) {
        return (StdItemPriceEo) BaseEo.newInstance(StdItemPriceEo.class, extFields);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Long getPoints() {
        return points;
    }

    public void setPoints(Long points) {
        this.points = points;
    }

    public String getPriceGroup() {
        return priceType;
    }

    public void setPriceGroup(String priceGroup) {
        this.priceType = priceGroup;
    }

    public Integer getIsActived() {
        return isActived;
    }

    public void setIsActived(Integer isActived) {
        this.isActived = isActived;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getPriceType() {
        return priceType;
    }

    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }

    public Long getPriceTypeId() {
        return priceTypeId;
    }

    public void setPriceTypeId(Long priceTypeId) {
        this.priceTypeId = priceTypeId;
    }
}
