/*
 * @(#)PriceTypeEo.java 1.0 2018-09-03
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 价格类型 eo
 *
 * @author
 * @since 2.0.0
 */
@Table(name = "it_item_price_type")
public class StdItemPriceTypeEo extends CubeBaseEo {

    /**
     * 编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;

    public static StdItemPriceTypeEo newInstance() {
        return (StdItemPriceTypeEo) BaseEo.newInstance(StdItemPriceTypeEo.class);
    }

    public static StdItemPriceTypeEo newInstance(Map<String, Object> extFields) {
        return (StdItemPriceTypeEo) BaseEo.newInstance(StdItemPriceTypeEo.class, extFields);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}