/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品与标签关联 Eo
 *
 * @author 佐助
 * @since 2.0.0
 */
@Table(name = "it_r_item_tag")
public class StdItemTagRelationEo extends CubeBaseEo {
    /**
     * 标签ID
     */
    @Column(name = "tag_id")
    private Long tagId;
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 规格ID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 状态
     */
    @Column(name = "status")
    private Integer status;

    public static StdItemTagRelationEo newInstance() {
        return (StdItemTagRelationEo) BaseEo.newInstance(StdItemTagRelationEo.class);
    }

    public static StdItemTagRelationEo newInstance(Map<String, Object> extFields) {
        return (StdItemTagRelationEo) BaseEo.newInstance(StdItemTagRelationEo.class, extFields);
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
