package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 属性值
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_prop_value")
public class StdPropValueEo extends CubeBaseEo {
    /**
     * 属性名ID
     */
    @Column(name = "prop_name_id")
    private Long propNameId;
    /**
     * 编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 1 自定义 2 单选 3多选
     */
    @Column(name = "input_type")
    private Integer inputType;
    /**
     * 排序
     */
    @Column(name = "sort")
    private Integer sort;

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;

    public static StdPropValueEo newInstance() {
        return (StdPropValueEo) BaseEo.newInstance(StdPropValueEo.class);
    }

    public static StdPropValueEo newInstance(Map<String, Object> extFields) {
        return (StdPropValueEo) BaseEo.newInstance(StdPropValueEo.class, extFields);
    }

    public void setPropNameId(Long propNameId) {
        this.propNameId = propNameId;
    }

    public Long getPropNameId() {
        return this.propNameId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInputType(Integer inputType) {
        this.inputType = inputType;
    }

    public Integer getInputType() {
        return this.inputType;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return this.sort;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
}