package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;
import java.util.Map;

/**
 * 库存变更日志
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_storage_change_log")
public class StdStorageChangeLogEo extends CubeBaseEo {
    /**
     * 上架ID
     */
    @Column(name = "shelf_id")
    private Long shelfId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 渠道ID
     */
    @Column(name = "channel_id")
    private Long channelId;
    /**
     * 商品ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * SKUID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 订单编码
     */
    @Column(name = "order_no")
    private String orderNo;
    /**
     * 已占用数量
     */
    @Column(name = "appending")
    private Long appending;
    /**
     * 预售数量
     */
    @Column(name = "presell")
    private Long presell;
    /**
     * 活动库存
     */
    @Column(name = "activity")
    private Long activity;
    /**
     * 状态 1 预占 2已确认 3已取消 4确认后取消
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 预占时间
     */
    @Column(name = "preemption_time")
    private Date preemptionTime;
    /**
     * 确认时间
     */
    @Column(name = "confirm_time")
    private Date confirmTime;
    /**
     * 取消时间
     */
    @Column(name = "cancellation_time")
    private Date cancellationTime;

    public static StdStorageChangeLogEo newInstance() {
        return (StdStorageChangeLogEo) BaseEo.newInstance(StdStorageChangeLogEo.class);
    }

    public static StdStorageChangeLogEo newInstance(Map<String, Object> extFields) {
        return (StdStorageChangeLogEo) BaseEo.newInstance(StdStorageChangeLogEo.class, extFields);
    }

    public void setShelfId(Long shelfId) {
        this.shelfId = shelfId;
    }

    public Long getShelfId() {
        return this.shelfId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getShopId() {
        return this.shopId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getItemId() {
        return this.itemId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getSkuId() {
        return this.skuId;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setAppending(Long appending) {
        this.appending = appending;
    }

    public Long getAppending() {
        return this.appending;
    }

    public void setPresell(Long presell) {
        this.presell = presell;
    }

    public Long getPresell() {
        return this.presell;
    }

    public void setActivity(Long activity) {
        this.activity = activity;
    }

    public Long getActivity() {
        return this.activity;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setPreemptionTime(Date preemptionTime) {
        this.preemptionTime = preemptionTime;
    }

    public Date getPreemptionTime() {
        return this.preemptionTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public Date getConfirmTime() {
        return this.confirmTime;
    }

    public void setCancellationTime(Date cancellationTime) {
        this.cancellationTime = cancellationTime;
    }

    public Date getCancellationTime() {
        return this.cancellationTime;
    }
}