package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 属性组
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_prop_group")
public class StdPropGroupEo extends CubeBaseEo {
    /**
     * 分组编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 分组名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 描述
     */
    @Column(name = "description")
    private String description;

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;

    /**
     * 排序
     */
    @Column(name = "sort")
    private Integer sort;

    public static StdPropGroupEo newInstance() {
        return (StdPropGroupEo) BaseEo.newInstance(StdPropGroupEo.class);
    }

    public static StdPropGroupEo newInstance(Map<String, Object> extFields) {
        return (StdPropGroupEo) BaseEo.newInstance(StdPropGroupEo.class, extFields);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Integer getSort() {
        return this.sort;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}