package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 商品
 *
 * @author 风影
 * @since 2.0.0
 */
@Table(name = "it_item")
public class StdItemEo extends CubeBaseEo {
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 显示名
     */
    @Column(name = "display_name")
    private String displayName;
    /**
     * 编码
     */
    @Column(name = "code")
    private String code;
    /**
     * 品牌名称
     */
    @Column(name = "brand")
    private String brand;
    /**
     * 品牌ID
     */
    @Column(name = "brand_id")
    private Long brandId;
    /**
     * 虚拟商品
     */
    @Column(name = "vitrual")
    private Boolean vitrual;
    /**
     * 简介
     */
    @Column(name = "brief")
    private String brief;
    /**
     * 状态(0可用 1已上架 2已下架 3不可用)
     */
    @Column(name = "status")
    private Integer status;
    /**
     * 退货类型：1不可退 2手动可退 3过期自动退
     */
    @Column(name = "return_type")
    private Integer returnType;
    /**
     * 允许退货时间点
     */
    @Column(name = "allow_return_time")
    private String allowReturnTime;
    /**
     * 商品类型: 1-商品  3 虚拟商品
     */
    @Column(name = "type")
    private Integer type;
    /**
     * 产品id
     */
    @Column(name = "spuid")
    private Long spuid;
    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 店铺ID
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 运费模板
     */
    @Column(name = "shipping_tpl")
    private Long shippingTpl;
    /**
     * 创建人
     */
    @Column(name = "owner_id")
    private Long ownerId;
    /**
     * 商品版本
     */
    @Column(name = "version")
    private Long version;
    /**
     * 详情
     */
    @Column(name = "detail")
    private String detail;
    /**
     * 可卖数量
     */
    @Column(name = "shelf_amount")
    private Long shelfAmount;
    /**
     * 目录Id
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 目录名称
     */
    @Column(name = "dir_name")
    private String dirName;

    /**
     * 供应商Id
     */
    @Column(name = "supplier_id")
    private Long supplierId;

    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @Column(name = "bus_type")
    private Integer busType;
    /**
     * 是否需要售后: 0否 1 是
     */
    @Column(name = "is_after_sale")
    private Integer isAfterSale;

    /**
     * 可售渠道,存储销交易中心的-tr_chanel表的code值，多个用英文逗号隔开
     */
    @Column(name = "sale_channel")
    private String saleChannel;

    /**
     * 所属年份 例如：2020
     */
    @Column(name = "year")
    private Integer year;

    /**
     * 组织Id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;

    /**
     * 零售限购周期
     */
    @Column(name = "retail_limit_period")
    private String retailLimitPeriod;
    /**
     * 零售限购
     */
    @Column(name = "retail_limit")
    private String retailLimit;
    /**
     * 最小起售量（单次购买）
     */
    @Column(name = "retail_limit_min")
    private String retailLimitMin;
    /**
     * 最大零售量（单次购买）
     */
    @Column(name = "retail_limit_max")
    private String retailLimitMax;
    /**
     * 订货限购周期
     */
    @Column(name = "wholesale_limit_period")
    private String wholesaleLimitPeriod;
    /**
     * 订货限购
     */
    @Column(name = "wholesale_limit")
    private String wholesaleLimit;
    /**
     * 最小订货量（单次购买）
     */
    @Column(name = "wholesale_limit_min")
    private String wholesaleLimitMin;
    /**
     * 最大订货量（单次购买）
     */
    @Column(name = "wholesale_limit_max")
    private String wholesaleLimitMax;

    /**
     * 属性组信息
     */
    @Column(name = "prop_group_info")
    private String propGroupInfo;

    /**
     * 商品子类型，1-产品，2-赠品，3-物料
     */
    @Column(name = "sub_type")
    private Integer subType;

    /**
     * 商品长编码
     */
    @Column(name = "long_code")
    private String longCode;

    /**
     * 是否礼盒（0：是、1：否）
     */
    @Column(name = "gift_box")
    private Integer giftBox;

    /**
     * 剂型
     */
    @Column(name = "dosage_form")
    private String dosageForm;

    public String getDosageForm() {
        return dosageForm;
    }

    public void setDosageForm(String dosageForm) {
        this.dosageForm = dosageForm;
    }

    public String getLongCode() {
        return longCode;
    }

    public void setLongCode(String longCode) {
        this.longCode = longCode;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public String getPropGroupInfo() {
        return propGroupInfo;
    }

    public void setPropGroupInfo(String propGroupInfo) {
        this.propGroupInfo = propGroupInfo;
    }

    public String getRetailLimitPeriod() {
        return retailLimitPeriod;
    }

    public void setRetailLimitPeriod(String retailLimitPeriod) {
        this.retailLimitPeriod = retailLimitPeriod;
    }

    public String getRetailLimit() {
        return retailLimit;
    }

    public void setRetailLimit(String retailLimit) {
        this.retailLimit = retailLimit;
    }

    public String getRetailLimitMin() {
        return retailLimitMin;
    }

    public void setRetailLimitMin(String retailLimitMin) {
        this.retailLimitMin = retailLimitMin;
    }

    public String getRetailLimitMax() {
        return retailLimitMax;
    }

    public void setRetailLimitMax(String retailLimitMax) {
        this.retailLimitMax = retailLimitMax;
    }

    public String getWholesaleLimitPeriod() {
        return wholesaleLimitPeriod;
    }

    public void setWholesaleLimitPeriod(String wholesaleLimitPeriod) {
        this.wholesaleLimitPeriod = wholesaleLimitPeriod;
    }

    public String getWholesaleLimit() {
        return wholesaleLimit;
    }

    public void setWholesaleLimit(String wholesaleLimit) {
        this.wholesaleLimit = wholesaleLimit;
    }

    public String getWholesaleLimitMin() {
        return wholesaleLimitMin;
    }

    public void setWholesaleLimitMin(String wholesaleLimitMin) {
        this.wholesaleLimitMin = wholesaleLimitMin;
    }

    public String getWholesaleLimitMax() {
        return wholesaleLimitMax;
    }

    public void setWholesaleLimitMax(String wholesaleLimitMax) {
        this.wholesaleLimitMax = wholesaleLimitMax;
    }

    public Integer getIsAfterSale() {
        return isAfterSale;
    }

    public void setIsAfterSale(Integer isAfterSale) {
        this.isAfterSale = isAfterSale;
    }

    public static StdItemEo newInstance() {
        return (StdItemEo) BaseEo.newInstance(StdItemEo.class);
    }

    public static StdItemEo newInstance(Map<String, Object> extFields) {
        return (StdItemEo) BaseEo.newInstance(StdItemEo.class, extFields);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public Boolean getVitrual() {
        return vitrual;
    }

    public void setVitrual(Boolean vitrual) {
        this.vitrual = vitrual;
    }

    public String getBrief() {
        return brief;
    }

    public void setBrief(String brief) {
        this.brief = brief;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getReturnType() {
        return returnType;
    }

    public void setReturnType(Integer returnType) {
        this.returnType = returnType;
    }

    public String getAllowReturnTime() {
        return allowReturnTime;
    }

    public void setAllowReturnTime(String allowReturnTime) {
        this.allowReturnTime = allowReturnTime;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSpuid() {
        return spuid;
    }

    public void setSpuid(Long spuid) {
        this.spuid = spuid;
    }

    public Long getShippingTpl() {
        return shippingTpl;
    }

    public void setShippingTpl(Long shippingTpl) {
        this.shippingTpl = shippingTpl;
    }

    public Long getShelfAmount() {
        return shelfAmount;
    }

    public void setShelfAmount(Long shelfAmount) {
        this.shelfAmount = shelfAmount;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getDetail() {
        return detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Integer getGiftBox() {
        return giftBox;
    }

    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }
    //    public Long getSnapshotId() {
//        return snapshotId;
//    }
//
//    public void setSnapshotId(Long snapshotId) {
//        this.snapshotId = snapshotId;
//    }


    public String getSaleChannel() {
        return saleChannel;
    }

    public void setSaleChannel(String saleChannel) {
        this.saleChannel = saleChannel;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }
}