package com.dtyunxi.yundt.cube.center.item.dao.eo.base;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import com.dtyunxi.eo.BaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Map;

/**
 * 目录属性
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Table(name = "it_r_dir_prop")
public class StdDirPropRelationEo extends CubeBaseEo {

    /**
     * 目录id
     */
    @Column(name = "dir_id")
    private Long dirId;
    /**
     * 1 属性组 2属性
     */
    @Column(name = "prop_type")
    private Integer propType;

    /**
     * 属性用途类型: 0 基础属性 1 销售属性
     */
    @Column(name = "prop_group_usage_type")
    private Integer propGroupUsageType;
    /**
     * 属性名ID
     */
    @Column(name = "prop_name_id")
    private Long propNameId;
    /**
     * 属性组ID
     */
    @Column(name = "prop_group_id")
    private Long propGroupId;

    /**
     * 商户ID
     */
    @Column(name = "seller_id")
    private Long sellerId;

    public Long getDirId() {
        return dirId;
    }

    public void setDirId(Long dirId) {
        this.dirId = dirId;
    }

    public static StdDirPropRelationEo newInstance() {
        return (StdDirPropRelationEo) BaseEo.newInstance(StdDirPropRelationEo.class);
    }

    public static StdDirPropRelationEo newInstance(Map<String, Object> extFields) {
        return (StdDirPropRelationEo) BaseEo.newInstance(StdDirPropRelationEo.class, extFields);
    }

    public void setPropType(Integer propType) {
        this.propType = propType;
    }

    public Integer getPropType() {
        return this.propType;
    }

    public Integer getPropGroupUsageType() {
        return propGroupUsageType;
    }

    public void setPropGroupUsageType(Integer propGroupUsageType) {
        this.propGroupUsageType = propGroupUsageType;
    }

    public void setPropNameId(Long propNameId) {
        this.propNameId = propNameId;
    }

    public Long getPropNameId() {
        return this.propNameId;
    }

    public void setPropGroupId(Long propGroupId) {
        this.propGroupId = propGroupId;
    }

    public Long getPropGroupId() {
        return this.propGroupId;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
}