package com.yx.tcbj.center.dao.eo;


import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 供应商和产品的供货价格
 */
@Table(name = "it_seller_sku_price")
public class StdSellerSkuPriceEo extends CubeBaseEo {
    /**
     * 卖家（商家/大B）ID
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 买家（客户/小B）ID
     */
    @Column(name = "customer_id")
    private Long customerId;
    /**
     * Item ID
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * SKU ID
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 零售价
     */
    @Column(name = "retail_price")
    private BigDecimal retailPrice;
    /**
     * 供货价
     */
    @Column(name = "supply_price")
    private BigDecimal supplyPrice;
    /**
     * 商铺列表信息
     */
    @Column(name = "shop_id")
    private Long shopId;

    @Column(name = "shop_name")
    private String shopName;

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public BigDecimal getSupplyPrice() {
        return supplyPrice;
    }

    public void setSupplyPrice(BigDecimal supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public BigDecimal getRetailPrice() {
        return retailPrice;
    }

    public void setRetailPrice(BigDecimal retailPrice) {
        this.retailPrice = retailPrice;
    }

}
