/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.sap.interceptor.controller;

import com.dtyunxi.sap.interceptor.config.SapConfigProperties;
import com.dtyunxi.sap.interceptor.config.SapDictManager;
import com.dtyunxi.sap.interceptor.feign.DictDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sap/dict"})
@Api(tags={"SAP\u5b57\u5178\u914d\u7f6e\u7ba1\u7406"})
public class SapDictController {
    private static final Logger log = LoggerFactory.getLogger(SapDictController.class);
    @Resource
    private SapDictManager sapDictManager;
    @Resource
    private SapConfigProperties sapConfigProperties;

    @GetMapping(value={"/all"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7f13\u5b58\u7684\u5b57\u5178\u914d\u7f6e")
    public Map<String, DictDto> getAllDictConfigs() {
        log.info("\u83b7\u53d6\u6240\u6709\u5b57\u5178\u914d\u7f6e");
        return this.sapDictManager.getAllDictConfigs();
    }

    @GetMapping(value={"/config"})
    @ApiOperation(value="\u6839\u636e\u5206\u7ec4\u548c\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u914d\u7f6e")
    public DictDto getDictConfig(@ApiParam(value="\u5206\u7ec4\u4ee3\u7801") @RequestParam String groupCode, @ApiParam(value="\u914d\u7f6e\u4ee3\u7801") @RequestParam String code) {
        log.info("\u83b7\u53d6\u5b57\u5178\u914d\u7f6e: groupCode={}, code={}", (Object)groupCode, (Object)code);
        return this.sapDictManager.getDictConfig(groupCode, code);
    }

    @GetMapping(value={"/group/{groupCode}"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u5206\u7ec4\u7684\u5b57\u5178\u914d\u7f6e")
    public List<DictDto> getDictGroup(@ApiParam(value="\u5206\u7ec4\u4ee3\u7801") @PathVariable String groupCode) {
        log.info("\u83b7\u53d6\u5b57\u5178\u5206\u7ec4: groupCode={}", (Object)groupCode);
        return this.sapDictManager.getDictGroup(groupCode);
    }

    @PostMapping(value={"/refresh/{groupCode}"})
    @ApiOperation(value="\u624b\u52a8\u5237\u65b0\u6307\u5b9a\u5206\u7ec4\u7684\u5b57\u5178\u914d\u7f6e")
    public String refreshGroup(@ApiParam(value="\u5206\u7ec4\u4ee3\u7801") @PathVariable String groupCode) {
        log.info("\u624b\u52a8\u5237\u65b0\u5b57\u5178\u5206\u7ec4: groupCode={}", (Object)groupCode);
        this.sapDictManager.refreshGroup(groupCode);
        return "\u5237\u65b0\u5b8c\u6210: " + groupCode;
    }

    @PostMapping(value={"/refresh/all"})
    @ApiOperation(value="\u624b\u52a8\u5237\u65b0\u6240\u6709\u5b57\u5178\u914d\u7f6e")
    public String refreshAll() {
        log.info("\u624b\u52a8\u5237\u65b0\u6240\u6709\u5b57\u5178\u914d\u7f6e");
        this.sapDictManager.loadAllSapConfigs();
        return "\u6240\u6709\u914d\u7f6e\u5237\u65b0\u5b8c\u6210";
    }

    @PostMapping(value={"/cache/clear"})
    @ApiOperation(value="\u6e05\u7a7a\u5b57\u5178\u914d\u7f6e\u7f13\u5b58")
    public String clearCache() {
        log.info("\u6e05\u7a7a\u5b57\u5178\u914d\u7f6e\u7f13\u5b58");
        this.sapDictManager.clearCache();
        return "\u7f13\u5b58\u5df2\u6e05\u7a7a";
    }

    @GetMapping(value={"/cache/stats"})
    @ApiOperation(value="\u83b7\u53d6\u7f13\u5b58\u7edf\u8ba1\u4fe1\u606f")
    public String getCacheStats() {
        log.info("\u83b7\u53d6\u7f13\u5b58\u7edf\u8ba1\u4fe1\u606f");
        return this.sapDictManager.getCacheStats();
    }

    @GetMapping(value={"/properties"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524dSAP\u914d\u7f6e\u5c5e\u6027")
    public SapConfigProperties getSapProperties() {
        log.info("\u83b7\u53d6SAP\u914d\u7f6e\u5c5e\u6027");
        return this.sapConfigProperties;
    }

    @GetMapping(value={"/properties/global"})
    @ApiOperation(value="\u83b7\u53d6\u5168\u5c40\u914d\u7f6e")
    public SapConfigProperties.GlobalConfig getGlobalConfig() {
        log.info("\u83b7\u53d6\u5168\u5c40\u914d\u7f6e");
        return this.sapConfigProperties.getGlobal();
    }

    @GetMapping(value={"/properties/mybatis"})
    @ApiOperation(value="\u83b7\u53d6MyBatis\u914d\u7f6e")
    public SapConfigProperties.MybatisConfig getMybatisConfig() {
        log.info("\u83b7\u53d6MyBatis\u914d\u7f6e");
        return this.sapConfigProperties.getMybatis();
    }

    @GetMapping(value={"/properties/path-mapping"})
    @ApiOperation(value="\u83b7\u53d6\u8def\u5f84\u6620\u5c04\u914d\u7f6e")
    public List<SapConfigProperties.PathMapping> getPathMappingConfig() {
        log.info("\u83b7\u53d6\u8def\u5f84\u6620\u5c04\u914d\u7f6e");
        return this.sapConfigProperties.getPathMapping();
    }

    @GetMapping(value={"/properties/header"})
    @ApiOperation(value="\u83b7\u53d6\u8bf7\u6c42\u5934\u914d\u7f6e")
    public SapConfigProperties.HeaderConfig getHeaderConfig() {
        log.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u914d\u7f6e");
        return this.sapConfigProperties.getHeader();
    }

    @GetMapping(value={"/properties/feign"})
    @ApiOperation(value="\u83b7\u53d6Feign\u914d\u7f6e")
    public SapConfigProperties.FeignConfig getFeignConfig() {
        log.info("\u83b7\u53d6Feign\u914d\u7f6e");
        return this.sapConfigProperties.getFeign();
    }

    @GetMapping(value={"/properties/context"})
    @ApiOperation(value="\u83b7\u53d6\u4e0a\u4e0b\u6587\u914d\u7f6e")
    public SapConfigProperties.ContextConfig getContextConfig() {
        log.info("\u83b7\u53d6\u4e0a\u4e0b\u6587\u914d\u7f6e");
        return this.sapConfigProperties.getContext();
    }

    @GetMapping(value={"/properties/limit-time"})
    @ApiOperation(value="\u83b7\u53d6\u9650\u5236\u65f6\u95f4\u914d\u7f6e")
    public String getLimitTime() {
        log.info("\u83b7\u53d6\u9650\u5236\u65f6\u95f4\u914d\u7f6e");
        return this.sapConfigProperties.getLimitTime();
    }

    @GetMapping(value={"/health"})
    @ApiOperation(value="\u5065\u5eb7\u68c0\u67e5")
    public String health() {
        return "SAP\u5b57\u5178\u914d\u7f6e\u7ba1\u7406\u5668\u8fd0\u884c\u6b63\u5e38";
    }
}

