/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.api.query.IDgCustomerTypeQueryApi;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerTypePageReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerNameSimpleRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerTypeRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerTypeEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerService;
import com.yunxi.dg.base.center.customer.service.IDgCustomerTypeService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerTypeBrandService;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerTypeDirService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DgCustomerTypeQueryApiImpl
implements IDgCustomerTypeQueryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgCustomerTypeService iDgCustomerTypeService;
    @Resource
    private IDgRCustomerTypeDirService iDgRCustomerTypeDirService;
    @Resource
    private IDgRCustomerTypeBrandService iDgRCustomerTypeBrandService;
    @Autowired
    private IDgCustomerService iDgCustomerService;
    @Resource
    private IContext context;

    public RestResponse<List<DgCustomerTypeRespDto>> queryAllCustomerType(Integer type) {
        List<DgCustomerTypeEo> customerTypeEos = this.iDgCustomerTypeService.queryAllCustomerType(type);
        ArrayList<DgCustomerTypeRespDto> customerTypeRespDtos = new ArrayList<DgCustomerTypeRespDto>(customerTypeEos.size());
        Long orgId = this.iDgCustomerTypeService.getCurrentUserOrgIdNoException(this.context.userId());
        for (DgCustomerTypeEo customerTypeEo : customerTypeEos) {
            DgCustomerTypeRespDto customerTypeRespDto = this.getCustomerTypeRespDto(customerTypeEo, orgId);
            customerTypeRespDtos.add(customerTypeRespDto);
        }
        return new RestResponse(customerTypeRespDtos);
    }

    public RestResponse<List<DgCustomerTypeRespDto>> queryAllSimpleCustomerType(Integer type) {
        List<DgCustomerTypeEo> customerTypeEos = this.iDgCustomerTypeService.queryAllCustomerType(type);
        ArrayList<DgCustomerTypeRespDto> customerTypeRespDtos = new ArrayList<DgCustomerTypeRespDto>(customerTypeEos.size());
        for (DgCustomerTypeEo customerTypeEo : customerTypeEos) {
            DgCustomerTypeRespDto customerTypeRespDto = new DgCustomerTypeRespDto();
            DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
            customerTypeRespDtos.add(customerTypeRespDto);
        }
        return new RestResponse(customerTypeRespDtos);
    }

    private DgCustomerTypeRespDto getCustomerTypeRespDto(DgCustomerTypeEo customerTypeEo, Long orgInfoId) {
        DgCustomerTypeRespDto customerTypeRespDto = new DgCustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        customerTypeRespDto.setProductType("\u6307\u5b9a\u5206\u7c7b");
        customerTypeRespDto.setProductBrand("\u6307\u5b9a\u54c1\u724c");
        List<Long> dirIds = this.iDgRCustomerTypeDirService.findByCustomerTypeId(customerTypeEo.getId(), orgInfoId);
        List<Long> brandIds = this.iDgRCustomerTypeBrandService.findByCustomerTypeId(customerTypeEo.getId(), orgInfoId);
        customerTypeRespDto.setDirIds(dirIds);
        customerTypeRespDto.setProductBrandIds(brandIds);
        Integer i = this.iDgCustomerService.countByCustomerTypeId(customerTypeEo.getId());
        customerTypeRespDto.setCustomerNum(i);
        return customerTypeRespDto;
    }

    public RestResponse<PageInfo<DgCustomerTypeRespDto>> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        PageInfo<DgCustomerTypeEo> customerTypeRespDtoPageInfo = this.iDgCustomerService.queryCustomerTypeByPage(pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        ArrayList<DgCustomerTypeRespDto> list = new ArrayList<DgCustomerTypeRespDto>();
        Long orgId = this.iDgCustomerTypeService.getCurrentUserOrgIdNoException(this.context.userId());
        for (DgCustomerTypeEo customerTypeEo : customerTypeRespDtoPageInfo.getList()) {
            DgCustomerTypeRespDto customerTypeRespDto = this.getCustomerTypeRespDto(customerTypeEo, orgId);
            list.add(customerTypeRespDto);
        }
        BeanUtils.copyProperties(customerTypeRespDtoPageInfo, (Object)pageInfo);
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<DgCustomerTypeRespDto>> queryCustomerTypeByType(DgCustomerTypePageReqDto customerTypePageReqDto) {
        return new RestResponse(this.iDgCustomerTypeService.queryCustomerTypeByType(customerTypePageReqDto));
    }

    public RestResponse<DgCustomerTypeRespDto> queryById(Long id) {
        DgCustomerTypeEo customerTypeEo = this.iDgCustomerTypeService.queryById(id);
        DgCustomerTypeRespDto customerTypeRespDto = new DgCustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        return new RestResponse((Object)customerTypeRespDto);
    }

    public RestResponse<DgCustomerTypeRespDto> queryByCustomerId(Long customerId) {
        return new RestResponse((Object)this.iDgCustomerTypeService.queryByCustomerId(customerId));
    }

    public RestResponse<List<DgCustomerNameSimpleRespDto>> queryListByIds(List<Long> ids) {
        return new RestResponse(this.iDgCustomerTypeService.queryCustomerTyperNameListByIds(ids));
    }
}

